/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.builders;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Optional;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Values;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.services.verifier.plugin.client.Logger;
import org.drools.workbench.services.verifier.plugin.client.builders.ToString;
import org.drools.workbench.services.verifier.plugin.client.builders.TypeResolver;
import org.drools.workbench.services.verifier.plugin.client.builders.Utils;
import org.drools.workbench.services.verifier.plugin.client.builders.ValueResolveException;
import org.kie.soup.commons.validation.PortablePreconditions;

public class ValuesResolver {
    private final TypeResolver typeResolver;
    private final ConditionCol52 conditionColumn;
    private final DTCellValue52 realCellValue;
    private final Optional<String> operatorFromCell;
    private final AnalyzerConfiguration configuration;

    public ValuesResolver(AnalyzerConfiguration configuration, TypeResolver typeResolver, ConditionCol52 conditionColumn, DTCellValue52 realCellValue) {
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
        this.typeResolver = (TypeResolver)PortablePreconditions.checkNotNull((String)"typeResolver", (Object)typeResolver);
        this.conditionColumn = (ConditionCol52)PortablePreconditions.checkNotNull((String)"conditionColumn", (Object)conditionColumn);
        this.realCellValue = (DTCellValue52)PortablePreconditions.checkNotNull((String)"realCellValue", (Object)realCellValue);
        this.operatorFromCell = Utils.findOperatorFromCell(realCellValue);
    }

    public Values getValues() throws ValueResolveException {
        String type = this.getType();
        Values values = this.getValues(type);
        Logger.add("ConditionCol: " + ToString.toString(this.conditionColumn) + " realCellValue: " + ToString.toString(this.realCellValue) + " type: " + type + " values: " + values.toString());
        return values;
    }

    private Values getValues(String type) throws ValueResolveException {
        if (this.isTypeGuvnorEnum()) {
            return this.getStringValue();
        }
        if (type == null) {
            return this.getStringValue();
        }
        if (type.equals("String")) {
            return this.getStringValue();
        }
        if (type.equals("Numeric") || type.equals("BigDecimal")) {
            return this.getBigDecimalValue();
        }
        if (type.equals("BigInteger")) {
            return this.getBigIntegerValue();
        }
        if (type.equals("Byte")) {
            return this.getNumericValue();
        }
        if (type.equals("Double")) {
            return this.getDoubleValue();
        }
        if (type.equals("Float")) {
            return this.getNumericValue();
        }
        if (type.equals("Integer")) {
            return this.getIntegerValue();
        }
        if (type.equals("Long")) {
            return this.getLongValue();
        }
        if (type.equals("Short")) {
            return this.getShortValue();
        }
        if (type.equals("Boolean")) {
            return this.getBooleanValue();
        }
        if (type.equals("Date")) {
            return this.getDateValue();
        }
        if (type.equals("Comparable")) {
            return this.getStringValue();
        }
        return this.getStringValue();
    }

    private String getType() throws ValueResolveException {
        return this.typeResolver.getType(this.operatorFromCell);
    }

    private Values<Boolean> getBooleanValue() throws ValueResolveException {
        try {
            Boolean booleanValue = this.getBoolean();
            if (booleanValue != null) {
                return new Values(new Comparable[]{booleanValue});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Boolean Value");
        }
    }

    private Boolean getBoolean() {
        if (this.operatorFromCell.isPresent()) {
            return Utils.tryBoolean(this.getCellValueFromCellWithOperator());
        }
        return this.realCellValue.getBooleanValue();
    }

    private Values<Date> getDateValue() throws ValueResolveException {
        try {
            Date date = this.getDate();
            if (date != null) {
                return new Values(new Comparable[]{date});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Date Value");
        }
    }

    private Date getDate() {
        if (this.operatorFromCell.isPresent()) {
            return this.configuration.parse(this.getCellValueFromCellWithOperator());
        }
        return this.realCellValue.getDateValue();
    }

    private Values getNumericValue() throws ValueResolveException {
        try {
            if (this.realCellValue.getNumericValue() != null) {
                return new Values(new Comparable[]{(Comparable)((Object)this.realCellValue.getNumericValue())});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Numeric Value");
        }
    }

    private Values<String> getStringValue() throws ValueResolveException {
        try {
            if (this.operatorFromCell.isPresent()) {
                return this.resolveValue(this.getCellValueFromCellWithOperator());
            }
            return this.resolveValue(this.realCellValue.getStringValue());
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve String Value");
        }
    }

    private String getCellValueFromCellWithOperator() {
        return this.realCellValue.getStringValue().trim().substring(this.operatorFromCell.get().length()).trim();
    }

    private Values<String> resolveValue(String stringValue) {
        if (stringValue != null && !stringValue.isEmpty()) {
            if (this.conditionColumn.getOperator() != null && this.isOperatorForList()) {
                Values values = new Values();
                for (String item : stringValue.split(",")) {
                    values.add((Object)item.trim());
                }
                return values;
            }
            return new Values(new Comparable[]{stringValue});
        }
        return new Values();
    }

    private boolean isOperatorForList() {
        return this.conditionColumn.getOperator().equals("in") || this.conditionColumn.getOperator().equals("not in");
    }

    private Values<Short> getShortValue() throws ValueResolveException {
        try {
            Short aShort = this.getShort();
            if (aShort != null) {
                return new Values(new Comparable[]{aShort});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Short Value");
        }
    }

    private Short getShort() {
        if (this.operatorFromCell.isPresent()) {
            return Utils.tryShort(this.getCellValueFromCellWithOperator());
        }
        if (this.realCellValue.getNumericValue() != null) {
            return (Short)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        return Utils.tryShort(this.realCellValue.getStringValue());
    }

    private Values<Long> getLongValue() throws ValueResolveException {
        try {
            Long aLong = this.getLong();
            if (aLong != null) {
                return new Values(new Comparable[]{aLong});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Long value");
        }
    }

    private Long getLong() {
        if (this.operatorFromCell.isPresent()) {
            return Utils.tryLong(this.getCellValueFromCellWithOperator());
        }
        if (this.realCellValue.getNumericValue() != null) {
            return (Long)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        return Utils.tryLong(this.realCellValue.getStringValue());
    }

    private Values<Double> getDoubleValue() {
        Double aDouble = this.getDouble();
        if (aDouble != null) {
            return new Values(new Comparable[]{aDouble});
        }
        return new Values();
    }

    private Double getDouble() {
        if (this.operatorFromCell.isPresent()) {
            return Utils.tryDouble(this.getCellValueFromCellWithOperator());
        }
        if (this.realCellValue.getNumericValue() != null) {
            return (Double)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        return Utils.tryDouble(this.realCellValue.getStringValue());
    }

    private Values<BigInteger> getBigIntegerValue() throws ValueResolveException {
        try {
            BigInteger bigInteger = this.getBigInteger();
            if (bigInteger != null) {
                return new Values(new Comparable[]{bigInteger});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolved Big Integer");
        }
    }

    private BigInteger getBigInteger() {
        if (this.operatorFromCell.isPresent()) {
            return Utils.tryBigInteger(this.getCellValueFromCellWithOperator());
        }
        if (this.realCellValue.getNumericValue() != null) {
            return (BigInteger)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        return Utils.tryBigInteger(this.realCellValue.getStringValue());
    }

    private Values<BigDecimal> getBigDecimalValue() throws ValueResolveException {
        try {
            BigDecimal bigDecimal = this.getBigDecimal();
            if (bigDecimal != null) {
                return new Values(new Comparable[]{bigDecimal});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Big Decimal.");
        }
    }

    private BigDecimal getBigDecimal() {
        if (this.operatorFromCell.isPresent()) {
            return Utils.tryBigDecimal(this.getCellValueFromCellWithOperator());
        }
        if (this.realCellValue.getNumericValue() != null) {
            return (BigDecimal)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        return Utils.tryBigDecimal(this.realCellValue.getStringValue());
    }

    private Values<Integer> getIntegerValue() throws ValueResolveException {
        try {
            Integer integer = this.getInteger();
            if (integer != null) {
                return new Values(new Comparable[]{integer});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Integer Value");
        }
    }

    private Integer getInteger() {
        if (this.operatorFromCell.isPresent()) {
            return Utils.tryInteger(this.getCellValueFromCellWithOperator());
        }
        if (this.realCellValue.getNumericValue() != null) {
            return (Integer)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        return Utils.tryInteger(this.realCellValue.getStringValue());
    }

    private boolean isTypeGuvnorEnum() {
        return this.conditionColumn != null && this.conditionColumn.getValueList() != null && !this.conditionColumn.getValueList().trim().isEmpty();
    }
}

