/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.builders;

import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.FieldBase;
import org.drools.verifier.core.index.model.Fields;
import org.drools.verifier.core.index.model.Pattern;
import org.drools.verifier.core.index.model.Rule;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.services.verifier.plugin.client.api.HeaderMetaData;
import org.drools.workbench.services.verifier.plugin.client.builders.BuildException;
import org.drools.workbench.services.verifier.plugin.client.builders.BuilderFactory;
import org.drools.workbench.services.verifier.plugin.client.builders.PatternResolver;
import org.drools.workbench.services.verifier.plugin.client.builders.Utils;
import org.kie.soup.commons.validation.PortablePreconditions;

public class FieldResolver {
    private final BuilderFactory builderFactory;
    private final HeaderMetaData headerMetaData;
    private final AnalyzerConfiguration configuration;
    private BaseColumn baseColumn;
    private Rule rule;
    private Pattern pattern;
    private int columnIndex;

    public FieldResolver(BuilderFactory builderFactory, HeaderMetaData headerMetaData, AnalyzerConfiguration configuration) {
        this.builderFactory = (BuilderFactory)PortablePreconditions.checkNotNull((String)"builderFactory", (Object)builderFactory);
        this.headerMetaData = (HeaderMetaData)PortablePreconditions.checkNotNull((String)"headerMetaData", (Object)headerMetaData);
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
    }

    public Field resolveField(Pattern pattern, String fieldType, String factField, AnalyzerConfiguration configuration) {
        PortablePreconditions.checkNotNull((String)"pattern", (Object)pattern);
        PortablePreconditions.checkNotNull((String)"fieldType", (Object)fieldType);
        PortablePreconditions.checkNotNull((String)"factField", (Object)factField);
        Field first = (Field)((Fields.FieldSelector)pattern.getFields().where((Matcher)Field.name().is((Comparable)((Object)factField))).select()).first();
        if (first == null) {
            Field field = new Field(Utils.resolveObjectField(pattern.getObjectType(), fieldType, factField, configuration), pattern.getName(), fieldType, factField, configuration);
            pattern.getFields().add((FieldBase)field);
            return field;
        }
        return first;
    }

    public Field resolve() throws BuildException {
        if (this.rule != null) {
            return this.resolveField(this.getPattern(), this.getType(), this.getFactField(), this.configuration);
        }
        return this.resolveField(this.pattern, this.getType(), this.getFactField(), this.configuration);
    }

    private Pattern getPattern() {
        if (this.pattern != null) {
            return this.pattern;
        }
        PatternResolver patternResolver = this.builderFactory.getPatternResolver().with(this.rule).with(this.columnIndex);
        if (this.baseColumn instanceof ActionCol52) {
            return patternResolver.with(this.columnIndex).resolve();
        }
        return patternResolver.resolve();
    }

    private String getFactField() {
        if (this.baseColumn instanceof ConditionCol52) {
            return ((ConditionCol52)this.baseColumn).getFactField();
        }
        if (this.baseColumn instanceof ActionSetFieldCol52) {
            return ((ActionSetFieldCol52)this.baseColumn).getFactField();
        }
        if (this.baseColumn instanceof ActionInsertFactCol52) {
            return ((ActionInsertFactCol52)this.baseColumn).getFactField();
        }
        return null;
    }

    private String getType() {
        if (this.baseColumn instanceof ConditionCol52) {
            return ((ConditionCol52)this.baseColumn).getFieldType();
        }
        if (this.baseColumn instanceof ActionSetFieldCol52) {
            return ((ActionSetFieldCol52)this.baseColumn).getType();
        }
        if (this.baseColumn instanceof ActionInsertFactCol52) {
            return ((ActionInsertFactCol52)this.baseColumn).getType();
        }
        return null;
    }

    public FieldResolver with(BaseColumn actionCol52) {
        this.baseColumn = actionCol52;
        return this;
    }

    public FieldResolver with(Rule rule) {
        this.rule = rule;
        return this;
    }

    public FieldResolver with(Pattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public FieldResolver with(int columnIndex) {
        this.columnIndex = columnIndex;
        return this;
    }
}

