/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.builders;

import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.Index;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.BRLCondition;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Columns;
import org.drools.verifier.core.index.model.Condition;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.services.verifier.plugin.client.builders.BuildException;
import org.drools.workbench.services.verifier.plugin.client.builders.ValueResolveException;
import org.drools.workbench.services.verifier.plugin.client.builders.ValuesResolver;
import org.drools.workbench.services.verifier.plugin.client.builders.VerifierColumnUtilities;
import org.kie.soup.commons.validation.PortablePreconditions;

public class BRLConditionBuilder {
    private final Index index;
    private final AnalyzerConfiguration configuration;
    private final VerifierColumnUtilities utils;
    private BRLConditionVariableColumn conditionColumn;
    private DTCellValue52 realCellValue;
    private int columnIndex;

    public BRLConditionBuilder(Index index, VerifierColumnUtilities utils, AnalyzerConfiguration configuration) {
        this.index = (Index)PortablePreconditions.checkNotNull((String)"index", (Object)index);
        this.utils = (VerifierColumnUtilities)PortablePreconditions.checkNotNull((String)"utils", (Object)utils);
        this.configuration = (AnalyzerConfiguration)PortablePreconditions.checkNotNull((String)"configuration", (Object)configuration);
    }

    public Condition build() throws BuildException {
        PortablePreconditions.checkNotNull((String)"realCellValue", (Object)this.realCellValue);
        PortablePreconditions.checkNotNull((String)"columnIndex", (Object)this.columnIndex);
        try {
            return new BRLCondition(this.getColumn(), new ValuesResolver(this.utils, this.columnIndex, (ConditionCol52)this.conditionColumn, this.realCellValue).getValues(), this.configuration);
        }
        catch (ValueResolveException e) {
            throw new BuildException("Could not build BRLCondition because of: " + e.getMessage());
        }
    }

    private Column getColumn() {
        return (Column)((Columns.ColumnSelect)this.index.getColumns().where((Matcher)Column.index().is((Comparable)Integer.valueOf(this.columnIndex))).select()).first();
    }

    public BRLConditionBuilder with(BRLConditionVariableColumn conditionColumn) {
        this.conditionColumn = conditionColumn;
        return this;
    }

    public BRLConditionBuilder with(DTCellValue52 realCellValue) {
        this.realCellValue = realCellValue;
        return this;
    }

    public BRLConditionBuilder with(int columnIndex) {
        this.columnIndex = columnIndex;
        return this;
    }
}

