/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.plugin.client.builders;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.drools.verifier.core.index.keys.Values;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.services.verifier.plugin.client.Logger;
import org.drools.workbench.services.verifier.plugin.client.builders.ToString;
import org.drools.workbench.services.verifier.plugin.client.builders.ValueResolveException;
import org.drools.workbench.services.verifier.plugin.client.builders.VerifierColumnUtilities;
import org.kie.soup.commons.validation.PortablePreconditions;

public class ValuesResolver {
    private final VerifierColumnUtilities utils;
    private final int columnIndex;
    private final ConditionCol52 conditionColumn;
    private final DTCellValue52 realCellValue;

    public ValuesResolver(VerifierColumnUtilities utils, int columnIndex, ConditionCol52 conditionColumn, DTCellValue52 realCellValue) {
        this.utils = (VerifierColumnUtilities)PortablePreconditions.checkNotNull((String)"utils", (Object)utils);
        this.columnIndex = (Integer)PortablePreconditions.checkNotNull((String)"columnIndex", (Object)columnIndex);
        this.conditionColumn = (ConditionCol52)PortablePreconditions.checkNotNull((String)"conditionColumn", (Object)conditionColumn);
        this.realCellValue = (DTCellValue52)PortablePreconditions.checkNotNull((String)"realCellValue", (Object)realCellValue);
    }

    public Values getValues() throws ValueResolveException {
        String type = this.getType();
        Values values = this.getValues(type);
        Logger.add("ConditionCol: " + ToString.toString(this.conditionColumn) + " realCellValue: " + ToString.toString(this.realCellValue) + " type: " + type + " values: " + values.toString());
        return values;
    }

    private Values getValues(String type) throws ValueResolveException {
        if (this.isTypeGuvnorEnum()) {
            return this.getStringValue();
        }
        if (type == null) {
            return this.getStringValue();
        }
        if (type.equals("String")) {
            return this.getStringValue();
        }
        if (type.equals("Numeric") || type.equals("BigDecimal")) {
            return this.getBigDecimalValue();
        }
        if (type.equals("BigInteger")) {
            return this.getBigIntegerValue();
        }
        if (type.equals("Byte")) {
            return this.getNumericValue();
        }
        if (type.equals("Double")) {
            return this.getDoubleValue();
        }
        if (type.equals("Float")) {
            return this.getNumericValue();
        }
        if (type.equals("Integer")) {
            return this.getIntegerValue();
        }
        if (type.equals("Long")) {
            return this.getLongValue();
        }
        if (type.equals("Short")) {
            return this.getShortValue();
        }
        if (type.equals("Boolean")) {
            return this.getBooleanValue();
        }
        if (type.equals("Date")) {
            return this.getDateValue();
        }
        if (type.equals("Comparable")) {
            return this.getStringValue();
        }
        return this.getStringValue();
    }

    private String getType() throws ValueResolveException {
        try {
            Logger.add("Getting type from utils");
            String type = this.utils.getType((BaseColumn)this.conditionColumn, this.columnIndex);
            Logger.add("Resolver type from utils: " + type);
            return type;
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to get type for " + ToString.toString(this.conditionColumn) + " columnIndex: " + this.columnIndex, e);
        }
    }

    private Values<Boolean> getBooleanValue() throws ValueResolveException {
        try {
            Boolean booleanValue = this.realCellValue.getBooleanValue();
            if (booleanValue != null) {
                return new Values(new Comparable[]{booleanValue});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Boolean Value");
        }
    }

    private Values<Date> getDateValue() throws ValueResolveException {
        try {
            Date date = this.realCellValue.getDateValue();
            if (date != null) {
                return new Values(new Comparable[]{date});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Date Value");
        }
    }

    private Values getNumericValue() throws ValueResolveException {
        try {
            if (this.realCellValue.getNumericValue() != null) {
                return new Values(new Comparable[]{(Comparable)((Object)this.realCellValue.getNumericValue())});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Numeric Value");
        }
    }

    private Values<String> getStringValue() throws ValueResolveException {
        try {
            String stringValue = this.realCellValue.getStringValue();
            if (stringValue != null && !stringValue.isEmpty()) {
                if (this.conditionColumn.getOperator() != null && (this.conditionColumn.getOperator().equals("in") || this.conditionColumn.getOperator().equals("not in"))) {
                    Values values = new Values();
                    for (String item : stringValue.split(",")) {
                        values.add((Object)item.trim());
                    }
                    return values;
                }
                return new Values(new Comparable[]{stringValue});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve String Value");
        }
    }

    private Values<Short> getShortValue() throws ValueResolveException {
        try {
            Short aShort = this.getShort();
            if (aShort != null) {
                return new Values(new Comparable[]{aShort});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Short Value");
        }
    }

    private Short getShort() {
        if (this.realCellValue.getNumericValue() != null) {
            return (Short)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        try {
            return new Short(this.realCellValue.getStringValue());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private Values<Long> getLongValue() throws ValueResolveException {
        try {
            Long aLong = this.getLong();
            if (aLong != null) {
                return new Values(new Comparable[]{aLong});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Long value");
        }
    }

    private Long getLong() {
        if (this.realCellValue.getNumericValue() != null) {
            return (Long)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        try {
            return new Long(this.realCellValue.getStringValue());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private Values<Double> getDoubleValue() {
        Double aDouble = this.getDouble();
        if (aDouble != null) {
            return new Values(new Comparable[]{aDouble});
        }
        return new Values();
    }

    private Double getDouble() {
        if (this.realCellValue.getNumericValue() != null) {
            return (Double)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        try {
            return new Double(this.realCellValue.getStringValue());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private Values<BigInteger> getBigIntegerValue() throws ValueResolveException {
        try {
            BigInteger bigInteger = this.getBigInteger();
            if (bigInteger != null) {
                return new Values(new Comparable[]{bigInteger});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolved Big Integer");
        }
    }

    private BigInteger getBigInteger() {
        if (this.realCellValue.getNumericValue() != null) {
            return (BigInteger)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        try {
            return new BigInteger(this.realCellValue.getStringValue());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private Values<BigDecimal> getBigDecimalValue() throws ValueResolveException {
        try {
            BigDecimal bigDecimal = this.getBigDecimal();
            if (bigDecimal != null) {
                return new Values(new Comparable[]{bigDecimal});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Big Decimal.");
        }
    }

    private BigDecimal getBigDecimal() {
        if (this.realCellValue.getNumericValue() != null) {
            return (BigDecimal)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        try {
            return new BigDecimal(this.realCellValue.getStringValue());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private Values<Integer> getIntegerValue() throws ValueResolveException {
        try {
            Integer integer = this.getInteger();
            if (integer != null) {
                return new Values(new Comparable[]{integer});
            }
            return new Values();
        }
        catch (Exception e) {
            throw new ValueResolveException("Failed to resolve Integer Value");
        }
    }

    private Integer getInteger() {
        if (this.realCellValue.getNumericValue() != null) {
            return (Integer)this.realCellValue.getNumericValue();
        }
        if (this.realCellValue.getStringValue() == null || this.realCellValue.getStringValue().isEmpty()) {
            return null;
        }
        try {
            return new Integer(this.realCellValue.getStringValue());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private boolean isTypeGuvnorEnum() {
        return this.conditionColumn != null && this.conditionColumn.getValueList() != null && this.conditionColumn.getValueList().split(",").length != 0;
    }
}

