/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.index;

import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.Matchers;
import org.drools.workbench.services.verifier.api.client.index.keys.IndexKey;
import org.drools.workbench.services.verifier.api.client.index.keys.Key;
import org.drools.workbench.services.verifier.api.client.index.keys.UUIDKey;
import org.drools.workbench.services.verifier.api.client.index.keys.UpdatableKey;
import org.drools.workbench.services.verifier.api.client.index.keys.Value;
import org.drools.workbench.services.verifier.api.client.maps.KeyDefinition;
import org.drools.workbench.services.verifier.api.client.maps.util.HasIndex;
import org.drools.workbench.services.verifier.api.client.maps.util.HasKeys;
import org.kie.soup.commons.validation.PortablePreconditions;

public class Column
implements HasKeys,
HasIndex {
    private final UUIDKey uuidKey;
    private UpdatableKey<Column> indexKey;

    public Column(int columnIndex, AnalyzerConfiguration configuration) {
        PortablePreconditions.checkNotNull((String)"columnIndex", (Object)columnIndex);
        this.indexKey = new UpdatableKey(IndexKey.INDEX_ID, Integer.valueOf(columnIndex));
        this.uuidKey = configuration.getUUID(this);
    }

    public static Matchers index() {
        return new Matchers(IndexKey.INDEX_ID);
    }

    public static KeyDefinition[] keyDefinitions() {
        return new KeyDefinition[]{UUIDKey.UNIQUE_UUID, IndexKey.INDEX_ID};
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey, this.indexKey};
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public int getIndex() {
        return (Integer)this.indexKey.getSingleValueComparator();
    }

    @Override
    public void setIndex(int index) {
        if (this.indexKey.getSingleValue().equals(new Value(Integer.valueOf(index)))) {
            return;
        }
        UpdatableKey<Column> oldKey = this.indexKey;
        UpdatableKey newKey = new UpdatableKey(IndexKey.INDEX_ID, Integer.valueOf(index));
        this.indexKey = newKey;
        oldKey.update(newKey, this);
    }
}

