/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.maps;

import java.util.Collection;
import java.util.Set;
import org.drools.workbench.services.verifier.api.client.configuration.AnalyzerConfiguration;
import org.drools.workbench.services.verifier.api.client.index.keys.Key;
import org.drools.workbench.services.verifier.api.client.index.keys.UUIDKey;
import org.drools.workbench.services.verifier.api.client.maps.InspectorList;
import org.drools.workbench.services.verifier.api.client.maps.LeafInspectorList;
import org.drools.workbench.services.verifier.api.client.maps.MultiMap;
import org.drools.workbench.services.verifier.api.client.maps.MultiMapFactory;
import org.drools.workbench.services.verifier.api.client.maps.NewSubMapProvider;
import org.drools.workbench.services.verifier.api.client.maps.util.HasConflicts;
import org.drools.workbench.services.verifier.api.client.maps.util.HasKeys;
import org.drools.workbench.services.verifier.api.client.maps.util.HasRedundancy;
import org.drools.workbench.services.verifier.api.client.maps.util.RedundancyResult;
import org.drools.workbench.services.verifier.api.client.relations.Conflict;
import org.drools.workbench.services.verifier.api.client.relations.IsConflicting;
import org.drools.workbench.services.verifier.api.client.relations.IsRedundant;
import org.drools.workbench.services.verifier.api.client.relations.IsSubsuming;

public class InspectorMultiMap<GroupBy extends Comparable, Value extends IsConflicting & IsRedundant>
implements HasConflicts,
HasRedundancy,
IsConflicting,
IsRedundant,
IsSubsuming,
HasKeys {
    private final UUIDKey uuidKey;
    private MultiMap<GroupBy, Value, LeafInspectorList<Value>> map;

    public InspectorMultiMap(final AnalyzerConfiguration configuration) {
        this.uuidKey = configuration.getUUID(this);
        this.map = MultiMapFactory.make(true, new NewSubMapProvider<Value, LeafInspectorList<Value>>(){

            @Override
            public LeafInspectorList<Value> getNewSubMap() {
                return new LeafInspectorList(configuration);
            }
        });
    }

    @Override
    public Conflict hasConflicts() {
        for (Comparable groupBy : this.map.keySet()) {
            Conflict result = this.map.get(groupBy).hasConflicts();
            if (!result.foundIssue()) continue;
            return result;
        }
        return Conflict.EMPTY;
    }

    @Override
    public RedundancyResult<GroupBy, Value> hasRedundancy() {
        for (Comparable groupBy : this.map.keySet()) {
            RedundancyResult result = this.map.get(groupBy).hasRedundancy();
            if (!result.isTrue()) continue;
            return new RedundancyResult(groupBy, result);
        }
        return RedundancyResult.EMPTY;
    }

    public boolean conflicts(Object other) {
        if (other instanceof InspectorMultiMap) {
            for (Comparable groupBy : this.map.keySet()) {
                InspectorList list = ((InspectorMultiMap)other).map.get(groupBy);
                if (!(list instanceof InspectorList) || !this.map.get(groupBy).conflicts(list)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRedundant(Object other) {
        if (other instanceof InspectorMultiMap) {
            for (Comparable groupBy : this.map.keySet()) {
                if (this.map.get(groupBy).isRedundant(((InspectorMultiMap)other).map.get(groupBy))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean subsumes(Object other) {
        if (other instanceof InspectorMultiMap) {
            for (GroupBy groupBy : ((InspectorMultiMap)other).map.keySet()) {
                LeafInspectorList<Value> collection;
                InspectorList otherCollection = ((InspectorMultiMap)other).map.get((Comparable)groupBy);
                if (otherCollection.subsumes(collection = this.map.get((Comparable)groupBy))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }

    public Set<GroupBy> keySet() {
        return this.map.keySet();
    }

    public LeafInspectorList<Value> get(GroupBy groupBy) {
        return this.map.get(groupBy);
    }

    public void putAllValues(GroupBy groupBy, LeafInspectorList<Value> values) {
        this.map.putAllValues(groupBy, values);
    }

    public void put(GroupBy groupBy, Value value) {
        this.map.put(groupBy, value);
    }

    public void addAllValues(GroupBy groupBy, InspectorList<Value> list) {
        this.map.addAllValues(groupBy, list);
    }

    public Collection<Value> allValues() {
        return this.map.allValues();
    }
}

