/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.index.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import org.drools.workbench.services.verifier.api.client.index.keys.Value;
import org.drools.workbench.services.verifier.api.client.index.matchers.ExactMatcher;
import org.drools.workbench.services.verifier.api.client.index.matchers.FromMatcher;
import org.drools.workbench.services.verifier.api.client.index.matchers.Matcher;
import org.drools.workbench.services.verifier.api.client.index.matchers.ToMatcher;
import org.drools.workbench.services.verifier.api.client.index.select.ExactMatcherSearch;
import org.drools.workbench.services.verifier.api.client.maps.MultiMap;
import org.drools.workbench.services.verifier.api.client.maps.MultiMapFactory;
import org.uberfire.commons.validation.PortablePreconditions;

public class Select<T> {
    private final MultiMap<Value, T, List<T>> map;
    private final Matcher matcher;

    public Select(MultiMap<Value, T, List<T>> map, Matcher matcher) {
        this.map = (MultiMap)PortablePreconditions.checkNotNull((String)"map", map);
        this.matcher = (Matcher)PortablePreconditions.checkNotNull((String)"matcher", (Object)matcher);
    }

    public T first() {
        Entry<T> entry = this.firstEntry();
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    protected Entry<T> firstEntry() {
        MultiMap<Value, T, List<T>> subMap = this.asMap();
        if (subMap == null) {
            return null;
        }
        try {
            Value key = subMap.firstKey();
            List<T> list = this.getT(subMap, key);
            return new Entry<T>(key, list.iterator().next());
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public T last() {
        Entry<T> entry = this.lastEntry();
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    protected Entry<T> lastEntry() {
        MultiMap<Value, T, List<T>> subMap = this.asMap();
        if (subMap == null) {
            return null;
        }
        try {
            Value key = subMap.lastKey();
            List<T> list = this.getT(subMap, key);
            return new Entry<T>(key, list.get(list.size() - 1));
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private List<T> getT(MultiMap<Value, T, List<T>> subMap, Value key) {
        if (subMap == null || subMap.isEmpty()) {
            return null;
        }
        return subMap.get(key);
    }

    public Collection<T> all() {
        MultiMap<Value, T, List<T>> subMap = this.asMap();
        if (subMap == null) {
            return new ArrayList();
        }
        return subMap.allValues();
    }

    public MultiMap<Value, T, List<T>> asMap() {
        if (this.map == null) {
            return null;
        }
        if (this.map.isEmpty()) {
            return this.map;
        }
        if (this.matcher instanceof FromMatcher) {
            FromMatcher fromMatcher = (FromMatcher)this.matcher;
            Value lastKey = this.map.lastKey();
            if (lastKey == null) {
                return null;
            }
            if (fromMatcher.getFrom().compareTo(lastKey) > 0) {
                return null;
            }
            return this.map.subMap(fromMatcher.getFrom(), fromMatcher.includeValue(), lastKey, true);
        }
        if (this.matcher instanceof ToMatcher) {
            ToMatcher toMatcher = (ToMatcher)this.matcher;
            return this.map.subMap(this.map.firstKey(), true, toMatcher.getTo(), false);
        }
        if (this.matcher instanceof ExactMatcher) {
            return new ExactMatcherSearch<T>((ExactMatcher)this.matcher, this.map).search();
        }
        MultiMap result = MultiMapFactory.make();
        MultiMap.merge(result, this.map);
        return result;
    }

    public boolean exists() {
        MultiMap<Value, T, List<T>> subMap = this.asMap();
        if (subMap == null) {
            return false;
        }
        return !subMap.isEmpty();
    }

    protected class Entry<T> {
        private final Value key;
        private final T value;

        public Entry(Value key, T value) {
            this.key = key;
            this.value = value;
        }

        public Value getKey() {
            return this.key;
        }

        public T getValue() {
            return this.value;
        }
    }
}

