/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.services.verifier.api.client.relations;

import org.drools.workbench.services.verifier.api.client.maps.InspectorList;
import org.drools.workbench.services.verifier.api.client.relations.Conflict;
import org.drools.workbench.services.verifier.api.client.relations.ConflictResolver;
import org.drools.workbench.services.verifier.api.client.relations.SubsumptionResolver;

public class RelationResolver {
    private final ConflictResolver conflictResolver;
    private final SubsumptionResolver subsumptionResolver;
    private final InspectorList list;

    public RelationResolver(InspectorList list) {
        this(list, false);
    }

    public RelationResolver(InspectorList list, boolean record) {
        this.list = list;
        this.conflictResolver = new ConflictResolver(list, record);
        this.subsumptionResolver = new SubsumptionResolver(list, record);
    }

    public boolean isConflicting(InspectorList otherCollection) {
        return this.resolveConflict(otherCollection).foundIssue();
    }

    public Conflict resolveConflict(InspectorList otherCollection) {
        return this.conflictResolver.resolveConflict(otherCollection);
    }

    public boolean subsumes(InspectorList otherList) {
        if (this.list == null || otherList == null) {
            return false;
        }
        if (this.isConflicting(otherList)) {
            return false;
        }
        return this.subsumptionResolver.listSubsumesOther(otherList);
    }

    public boolean isRedundant(InspectorList otherList) {
        return this.subsumes(otherList) && otherList.subsumes(this.list);
    }
}

