/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.testscenarios.backend.util.ScenarioXMLPersistence;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.backend.server.ScenarioRunnerService;
import org.drools.workbench.screens.testscenario.backend.server.TestScenarioModelVisitor;
import org.drools.workbench.screens.testscenario.model.TestScenarioModelContent;
import org.drools.workbench.screens.testscenario.model.TestScenarioResult;
import org.drools.workbench.screens.testscenario.service.ScenarioTestEditorService;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class ScenarioTestEditorServiceImpl
extends KieService<TestScenarioModelContent>
implements ScenarioTestEditorService {
    private Logger logger = LoggerFactory.getLogger(ScenarioTestEditorServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private ScenarioRunnerService scenarioRunner;
    @Inject
    private CommentedOptionFactory commentedOptionFactory;
    @Inject
    private SaveAndRenameServiceImpl<Scenario, Metadata> saveAndRenameService;
    private SafeSessionInfo safeSessionInfo;

    public ScenarioTestEditorServiceImpl() {
    }

    @Inject
    public ScenarioTestEditorServiceImpl(SessionInfo sessionInfo) {
        this.safeSessionInfo = new SafeSessionInfo(sessionInfo);
    }

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, Scenario content, String comment) {
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, ScenarioXMLPersistence.getInstance().marshal(content), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Scenario load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            Scenario scenario = ScenarioXMLPersistence.getInstance().unmarshal(content);
            scenario.setName(path.getFileName());
            return scenario;
        }
        catch (Exception e) {
            this.logger.error("Unable to unmarshal content. Returning an empty Test Scenario.", (Throwable)e);
            Package resolvedPackage = this.moduleService.resolvePackage(path);
            Scenario scenario = new Scenario();
            if (resolvedPackage != null) {
                scenario.setPackageName(resolvedPackage.getPackageName());
            }
            scenario.setImports(new Imports());
            return scenario;
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, Scenario content, Metadata metadata, String comment) {
        try {
            Metadata currentMetadata = this.metadataService.getMetadata(resource);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), ScenarioXMLPersistence.getInstance().marshal(content), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            this.fireMetadataSocialEvents(resource, currentMetadata, metadata);
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        try {
            return this.copyService.copy(path, newName, targetDirectory, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public TestScenarioModelContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (TestScenarioModelContent)super.loadContent(path);
    }

    protected TestScenarioModelContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        Scenario scenario = this.load(path);
        String packageName = this.moduleService.resolvePackage(path).getPackageName();
        PackageDataModelOracle dataModelOracle = this.getDataModel(path);
        PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
        Set<String> usedFullyQualifiedClassNames = this.getUsedFullyQualifiedClassNames(scenario, dataModelOracle);
        DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)dataModelOracle, (PackageDataModelOracleBaselinePayload)dataModel, usedFullyQualifiedClassNames);
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, (SessionInfo)this.safeSessionInfo));
        return new TestScenarioModelContent(scenario, overview, packageName, dataModel);
    }

    public TestScenarioResult runScenario(String userName, org.uberfire.backend.vfs.Path path, Scenario scenario) {
        Imports existingScenarioImports = new Imports(scenario.getImports().getImports());
        try {
            TestScenarioResult result;
            this.addDependentImportsToScenario(scenario, path);
            TestScenarioResult testScenarioResult = result = this.scenarioRunner.run(userName, scenario, (KieModule)this.moduleService.resolveModule(path));
            return testScenarioResult;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            scenario.setImports(existingScenarioImports);
        }
    }

    void addDependentImportsToScenario(Scenario scenario, org.uberfire.backend.vfs.Path path) {
        PackageDataModelOracle dataModel = this.getDataModel(path);
        Set<String> usedFullyQualifiedClassNames = this.getUsedFullyQualifiedClassNames(scenario, dataModel);
        for (String className : usedFullyQualifiedClassNames) {
            Import imp = new Import(className);
            List scenarioImports = scenario.getImports().getImports();
            if (scenarioImports.contains(imp)) continue;
            scenarioImports.add(imp);
        }
    }

    private PackageDataModelOracle getDataModel(org.uberfire.backend.vfs.Path path) {
        return this.dataModelService.getDataModel(path);
    }

    private Set<String> getUsedFullyQualifiedClassNames(final Scenario scenario, final PackageDataModelOracle dataModelOracle) {
        return new HashSet<String>(){
            {
                this.addAll(ScenarioTestEditorServiceImpl.this.getFullyQualifiedClassNamesUsedByModel(scenario, dataModelOracle));
                this.addAll(ScenarioTestEditorServiceImpl.this.getFullyQualifiedClassNamesUsedByGlobals(dataModelOracle));
            }
        };
    }

    private Set<String> getFullyQualifiedClassNamesUsedByModel(Scenario scenario, PackageDataModelOracle dataModelOracle) {
        HashSet<String> fullyQualifiedClassNames = new HashSet<String>();
        for (String fullyQualifiedClassName : this.getFullyQualifiedClassNameFromScenario(scenario)) {
            ModelField[] modelFields = (ModelField[])dataModelOracle.getModuleModelFields().get(fullyQualifiedClassName);
            if (modelFields == null) continue;
            for (ModelField modelField : modelFields) {
                fullyQualifiedClassNames.add(modelField.getClassName());
            }
            fullyQualifiedClassNames.add(fullyQualifiedClassName);
        }
        return fullyQualifiedClassNames;
    }

    private List<String> getFullyQualifiedClassNameFromScenario(final Scenario scenario) {
        final TestScenarioModelVisitor testScenarioModelVisitor = new TestScenarioModelVisitor(scenario);
        return new ArrayList<String>(){
            {
                this.addAll(testScenarioModelVisitor.visit());
                this.addAll(scenario.getImports().getImports().stream().collect(Collectors.mapping(Import::getType, Collectors.toList())));
            }
        };
    }

    private Collection<String> getFullyQualifiedClassNamesUsedByGlobals(PackageDataModelOracle dataModelOracle) {
        return dataModelOracle.getPackageGlobals().values();
    }

    public org.uberfire.backend.vfs.Path saveAndRename(org.uberfire.backend.vfs.Path path, String newFileName, Metadata metadata, Scenario content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }
}

