/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server.indexing;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.models.testscenarios.backend.util.ScenarioXMLPersistence;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.backend.server.indexing.TestScenarioIndexVisitor;
import org.drools.workbench.screens.testscenario.type.TestScenarioResourceTypeDefinition;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class TestScenarioFileIndexer
extends AbstractFileIndexer {
    @Inject
    private DataModelService dataModelService;
    @Inject
    protected KieProjectService projectService;
    @Inject
    protected TestScenarioResourceTypeDefinition type;

    public boolean supportsPath(Path path) {
        return this.type.accept(Paths.convert((Path)path));
    }

    public DefaultIndexBuilder fillIndexBuilder(Path path) throws Exception {
        String content = this.ioService.readAllString(path);
        Scenario model = ScenarioXMLPersistence.getInstance().unmarshal(content);
        ProjectDataModelOracle dmo = this.getProjectDataModelOracle(path);
        Project project = this.projectService.resolveProject(Paths.convert((Path)path));
        Package pkg = this.projectService.resolvePackage(Paths.convert((Path)path));
        DefaultIndexBuilder builder = new DefaultIndexBuilder(Paths.convert((Path)path).getFileName(), project, pkg);
        TestScenarioIndexVisitor visitor = new TestScenarioIndexVisitor(dmo, builder, model);
        visitor.visit();
        this.addReferencedResourcesToIndexBuilder(builder, visitor);
        return builder;
    }

    protected String getPackageName(Path path) {
        return this.projectService.resolvePackage(Paths.convert((Path)path)).getPackageName();
    }

    protected ProjectDataModelOracle getProjectDataModelOracle(Path path) {
        return this.dataModelService.getProjectDataModel(Paths.convert((Path)path));
    }
}

