/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.popup;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.popup.YesNoConfirmPopup;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.client.views.pfly.widgets.Button;
import org.uberfire.client.views.pfly.widgets.InlineNotification;
import org.uberfire.client.views.pfly.widgets.Modal;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class YesNoConfirmPopupView
implements YesNoConfirmPopup {
    @Inject
    @DataField(value="confirm-title")
    Span modalTitle;
    @Inject
    @DataField(value="confirm-inline-notification")
    InlineNotification confirmInlineNotification;
    @Inject
    @DataField(value="confirm-message")
    Span modalConfirmationMessageLabel;
    @Inject
    @DataField(value="confirm-cancel")
    Button cancelButton;
    @Inject
    @DataField(value="confirm-ok")
    Button okButton;
    @Inject
    @DataField(value="confirm-yes")
    Button yesButton;
    @Inject
    @DataField(value="confirm-no")
    Button noButton;
    @Inject
    @DataField(value="modal")
    Modal modal;
    @Inject
    private TranslationService translationService;
    Command okCommand;
    Command yesCommand;
    Command noCommand;

    @PostConstruct
    public void init() {
        this.cancelButton.setText(this.translationService.getTranslation("ConfirmPopup.Cancel"));
    }

    @Override
    public void show(String title, String okButtonText, String confirmMessage, Command okCommand) {
        this.show(title, null, null, okButtonText, Button.ButtonStyleType.DANGER, confirmMessage, okCommand);
    }

    @Override
    public void show(String title, String inlineNotificationMessage, InlineNotification.InlineNotificationType inlineNotificationType, String okButtonText, Button.ButtonStyleType okButtonType, String confirmMessage, Command okCommand) {
        this.okCommand = okCommand;
        this.okButton.show();
        this.yesButton.hide();
        this.noButton.hide();
        this.okButton.setText(okButtonText);
        if (okButtonType != null) {
            this.okButton.setButtonStyleType(okButtonType);
        }
        this.commonShow(title, inlineNotificationMessage, inlineNotificationType, confirmMessage);
    }

    @Override
    public void show(String title, String yesButtonText, String noButtonText, String confirmMessage, Command yesCommand, Command noCommand) {
        this.show(title, null, null, yesButtonText, noButtonText, Button.ButtonStyleType.DANGER, Button.ButtonStyleType.DEFAULT, confirmMessage, yesCommand, noCommand);
    }

    @Override
    public void show(String title, String inlineNotificationMessage, InlineNotification.InlineNotificationType inlineNotificationType, String yesButtonText, String noButtonText, Button.ButtonStyleType yesButtonType, Button.ButtonStyleType noButtonType, String confirmMessage, Command yesCommand, Command noCommand) {
        this.yesCommand = yesCommand;
        this.noCommand = noCommand;
        this.okButton.hide();
        this.yesButton.show();
        this.noButton.show();
        this.yesButton.setText(yesButtonText);
        this.noButton.setText(noButtonText);
        if (yesButtonType != null) {
            this.yesButton.setButtonStyleType(yesButtonType);
        }
        if (noButtonType != null) {
            this.noButton.setButtonStyleType(noButtonType);
        }
        this.commonShow(title, inlineNotificationMessage, inlineNotificationType, confirmMessage);
    }

    @Override
    public HTMLElement getElement() {
        return this.modal.getElement();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @EventHandler(value={"confirm-ok"})
    public void onOkClick(@ForEvent(value={"click"}) MouseEvent event) {
        if (this.okCommand != null) {
            this.okCommand.execute();
        }
        this.hide();
    }

    @EventHandler(value={"confirm-cancel"})
    public void onCancelClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"confirm-close"})
    public void onCloseClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"confirm-yes"})
    public void onYesClick(@ForEvent(value={"click"}) MouseEvent event) {
        if (this.yesCommand != null) {
            this.yesCommand.execute();
        }
        this.hide();
    }

    @EventHandler(value={"confirm-no"})
    public void onNoClick(@ForEvent(value={"click"}) MouseEvent event) {
        if (this.noCommand != null) {
            this.noCommand.execute();
        }
        this.hide();
    }

    protected void commonShow(String title, String inlineNotificationMessage, InlineNotification.InlineNotificationType inlineNotificationType, String confirmMessage) {
        this.modalTitle.setTextContent(title);
        if (inlineNotificationMessage != null && inlineNotificationType != null) {
            this.confirmInlineNotification.setMessage(inlineNotificationMessage);
            this.confirmInlineNotification.setType(inlineNotificationType);
            this.confirmInlineNotification.getElement().getStyle().removeProperty("display");
        } else {
            this.confirmInlineNotification.getElement().getStyle().setProperty("display", "none");
        }
        this.modalConfirmationMessageLabel.setTextContent(confirmMessage);
        this.modal.show();
    }
}

