/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.SimpleClassEntry;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.uberfire.client.callbacks.Callback;

public abstract class AbstractDMODataManagementStrategy
extends AbstractDataManagementStrategy {
    protected String packageName = "";

    protected abstract String getFQCNByFactName(String var1);

    protected abstract String getParametricFieldType(String var1, String var2);

    protected abstract List<String> getFactTypes();

    protected abstract void getSuperType(String var1, Callback<String> var2);

    protected abstract boolean skipPopulateTestTools();

    protected abstract void manageDataObjects(List<String> var1, Map<String, String> var2, TestToolsView.Presenter var3, int var4, SortedMap<String, FactModelTree> var5, ScenarioSimulationContext var6, List<String> var7, GridWidget var8);

    @Override
    public void populateTestTools(TestToolsView.Presenter testToolsPresenter, ScenarioSimulationContext context, GridWidget gridWidget) {
        if (this.factModelTreeHolder.getFactModelTuple() != null) {
            this.storeData(this.factModelTreeHolder.getFactModelTuple(), testToolsPresenter, context, gridWidget);
        } else {
            if (this.skipPopulateTestTools()) {
                testToolsPresenter.hideInstances();
                return;
            }
            List<String> factTypes = this.getFactTypes();
            Map<Boolean, List<String>> partitionedFactTypes = factTypes.stream().collect(Collectors.partitioningBy(factType -> SIMPLE_CLASSES_MAP.keySet().contains(factType)));
            List<String> dataObjectsTypes = partitionedFactTypes.get(false);
            List<String> simpleJavaTypes = partitionedFactTypes.get(true);
            int expectedElements = dataObjectsTypes.size();
            TreeMap<String, FactModelTree> dataObjectsFieldsMap = new TreeMap<String, FactModelTree>();
            HashMap<String, String> superTypesMap = new HashMap<String, String>();
            if (dataObjectsTypes.isEmpty()) {
                this.aggregatorCallbackMethod(testToolsPresenter, expectedElements, dataObjectsFieldsMap, context, null, simpleJavaTypes, gridWidget);
            } else {
                this.loadSuperTypes(dataObjectsTypes, testToolsPresenter, expectedElements, dataObjectsFieldsMap, superTypesMap, context, simpleJavaTypes, gridWidget);
            }
        }
    }

    protected void loadSuperTypes(List<String> dataObjectsTypes, TestToolsView.Presenter testToolsPresenter, int expectedElements, SortedMap<String, FactModelTree> dataObjectsFieldsMap, Map<String, String> superTypesMap, ScenarioSimulationContext context, List<String> simpleJavaTypes, GridWidget gridWidget) {
        dataObjectsTypes.forEach(factType -> this.getSuperType((String)factType, this.superTypeAggregatorCallBack(dataObjectsTypes, superTypesMap, testToolsPresenter, expectedElements, dataObjectsFieldsMap, context, simpleJavaTypes, gridWidget, (String)factType)));
    }

    protected Callback<String> superTypeAggregatorCallBack(List<String> dataObjectsTypes, Map<String, String> superTypeMap, TestToolsView.Presenter testToolsPresenter, int expectedElements, SortedMap<String, FactModelTree> dataObjectsFieldsMap, ScenarioSimulationContext context, List<String> simpleJavaTypes, GridWidget gridWidget, String factType) {
        return superType -> {
            superTypeMap.put(factType, (String)superType);
            if (superTypeMap.size() == expectedElements) {
                this.manageDataObjects(dataObjectsTypes, superTypeMap, testToolsPresenter, expectedElements, dataObjectsFieldsMap, context, simpleJavaTypes, gridWidget);
            }
        };
    }

    public FactModelTree getFactModelTree(String factName, Map<String, String> superTypeMap, ModelField[] modelFields) {
        HashMap<String, FactModelTree.PropertyTypeName> simpleProperties = new HashMap<String, FactModelTree.PropertyTypeName>();
        HashMap<String, List<String>> genericTypesMap = new HashMap<String, List<String>>();
        String fullFactClassName = this.getFQCNByFactName(factName);
        String factPackageName = this.packageName;
        String factClassName = fullFactClassName;
        if (fullFactClassName != null && fullFactClassName.contains(".")) {
            factPackageName = fullFactClassName.substring(0, fullFactClassName.lastIndexOf(46));
            factClassName = fullFactClassName.substring(fullFactClassName.lastIndexOf(46) + 1);
        }
        if (ScenarioSimulationSharedUtils.isEnumCanonicalName((String)superTypeMap.get(factName))) {
            simpleProperties.put("value", new FactModelTree.PropertyTypeName(fullFactClassName));
            return AbstractDMODataManagementStrategy.getSimpleClassFactModelTree(factName, fullFactClassName);
        }
        for (ModelField modelField : modelFields) {
            if (modelField.getName().equals("this")) continue;
            String className = this.defineClassNameField(modelField.getClassName(), superTypeMap);
            simpleProperties.put(modelField.getName(), new FactModelTree.PropertyTypeName(className));
            if (!ScenarioSimulationSharedUtils.isCollectionOrMap((String)className)) continue;
            this.populateGenericTypeMap(genericTypesMap, factName, modelField.getName(), ScenarioSimulationSharedUtils.isList((String)className));
        }
        return FactModelTree.ofDMO((String)factName, (String)factPackageName, simpleProperties, genericTypesMap, (String)factClassName);
    }

    protected String defineClassNameField(String modelFieldClassName, Map<String, String> superTypesMap) {
        if (SIMPLE_CLASSES_MAP.containsKey(modelFieldClassName)) {
            return ((SimpleClassEntry)SIMPLE_CLASSES_MAP.get(modelFieldClassName)).getCanonicalName();
        }
        if (ScenarioSimulationSharedUtils.isEnumCanonicalName((String)superTypesMap.get(modelFieldClassName))) {
            return this.getFQCNByFactName(modelFieldClassName);
        }
        return modelFieldClassName;
    }

    public void populateGenericTypeMap(Map<String, List<String>> toPopulate, String factName, String propertyName, boolean isList) {
        ArrayList<String> genericTypes = new ArrayList<String>();
        if (!isList) {
            genericTypes.add(String.class.getName());
        }
        String genericInfo = this.getParametricFieldType(factName, propertyName);
        String fullGenericInfoClassName = this.getFQCNByFactName(genericInfo);
        genericTypes.add(fullGenericInfoClassName);
        toPopulate.put(propertyName, genericTypes);
    }

    public void aggregatorCallbackMethod(TestToolsView.Presenter testToolsPresenter, int expectedElements, SortedMap<String, FactModelTree> factTypeFieldsMap, ScenarioSimulationContext context, FactModelTree result, List<String> simpleJavaTypes, GridWidget gridWidget) {
        if (result != null) {
            factTypeFieldsMap.put(result.getFactName(), result);
        }
        if (factTypeFieldsMap.size() == expectedElements) {
            factTypeFieldsMap.values().forEach(factModelTree -> this.populateFactModelTree((FactModelTree)factModelTree, factTypeFieldsMap));
            TreeMap<String, FactModelTree> simpleJavaTypeFieldsMap = new TreeMap<String, FactModelTree>(simpleJavaTypes.stream().collect(Collectors.toMap(factType -> factType, factType -> {
                SimpleClassEntry classEntry = (SimpleClassEntry)SIMPLE_CLASSES_MAP.get(factType);
                return AbstractDMODataManagementStrategy.getSimpleClassFactModelTree(classEntry.getSimpleName(), classEntry.getCanonicalName());
            })));
            TreeMap<String, FactModelTree> visibleFacts = new TreeMap<String, FactModelTree>(factTypeFieldsMap);
            visibleFacts.putAll(simpleJavaTypeFieldsMap);
            FactModelTuple factModelTuple = new FactModelTuple(visibleFacts, new TreeMap());
            this.factModelTreeHolder.setFactModelTuple(factModelTuple);
            this.storeData(factModelTuple, testToolsPresenter, context, gridWidget);
        }
    }

    public void populateFactModelTree(FactModelTree toPopulate, SortedMap<String, FactModelTree> factTypeFieldsMap) {
        ArrayList toRemove = new ArrayList();
        toPopulate.getSimpleProperties().forEach((key, value) -> {
            if (factTypeFieldsMap.containsKey(value.getTypeName())) {
                toRemove.add(key);
                toPopulate.addExpandableProperty(key, ((FactModelTree)factTypeFieldsMap.get(value.getTypeName())).getFactName());
            }
        });
        toRemove.forEach(arg_0 -> ((FactModelTree)toPopulate).removeSimpleProperty(arg_0));
    }
}

