/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import org.drools.scenariosimulation.api.model.FactMappingValueType;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioCommandManager;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioCommandRegistryManager;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationViolation;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationUndoableCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AppendColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AppendRowCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.DeleteColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.DeleteRowCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.DisableTestToolsCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.DuplicateInstanceCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.DuplicateRowCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.EnableTestToolsCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.ImportCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.InsertColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.InsertRowCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.PrependColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.PrependRowCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.ReloadTestToolsCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.RunSingleScenarioCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.SetGridCellValueCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.SetHeaderCellValueCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.SetInstanceHeaderCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.SetPropertyHeaderCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.UpdateSettingsDataCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.AppendColumnEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.AppendRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DeleteColumnEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DeleteRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DisableTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DuplicateInstanceEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DuplicateRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ImportEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.InsertColumnEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.InsertRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.PrependColumnEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.PrependRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.RedoEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.RunSingleScenarioEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioGridReloadEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioNotificationEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SetGridCellValueEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SetHeaderCellValueEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SetInstanceHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SetPropertyHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.UndoEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.UnsupportedDMNEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.UpdateSettingsDataEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ValidateSimulationEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AppendColumnEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AppendRowEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.DeleteColumnEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.DeleteRowEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.DisableTestToolsEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.DuplicateInstanceEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.DuplicateRowEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.EnableTestToolsEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ImportEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.InsertColumnEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.InsertRowEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.PrependColumnEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.PrependRowEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.RedoEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ReloadTestToolsEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.RunSingleScenarioEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioGridReloadEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioNotificationEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.SetGridCellValueEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.SetHeaderCellValueEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.SetInstanceHeaderEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.SetPropertyHeaderEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.UndoEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.UnsupportedDMNEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.UpdateSettingsDataEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ValidateSimulationEventHandler;
import org.drools.workbench.screens.scenariosimulation.client.models.AbstractScesimGridModel;
import org.drools.workbench.screens.scenariosimulation.client.popup.ConfirmPopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popup.DeletePopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popup.FileUploadPopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popup.PreserveDeletePopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.service.ImportExportType;
import org.kie.workbench.common.command.client.CommandResult;
import org.kie.workbench.common.command.client.CommandResultBuilder;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class ScenarioSimulationEventHandler
implements AppendColumnEventHandler,
AppendRowEventHandler,
DeleteColumnEventHandler,
DeleteRowEventHandler,
DisableTestToolsEventHandler,
DuplicateInstanceEventHandler,
DuplicateRowEventHandler,
EnableTestToolsEventHandler,
ImportEventHandler,
InsertColumnEventHandler,
InsertRowEventHandler,
PrependColumnEventHandler,
PrependRowEventHandler,
RedoEventHandler,
ReloadTestToolsEventHandler,
RunSingleScenarioEventHandler,
ScenarioGridReloadEventHandler,
ScenarioNotificationEventHandler,
SetGridCellValueEventHandler,
SetHeaderCellValueEventHandler,
SetInstanceHeaderEventHandler,
SetPropertyHeaderEventHandler,
UndoEventHandler,
UnsupportedDMNEventHandler,
UpdateSettingsDataEventHandler,
ValidateSimulationEventHandler {
    protected DeletePopupPresenter deletePopupPresenter;
    protected PreserveDeletePopupPresenter preserveDeletePopupPresenter;
    protected ConfirmPopupPresenter confirmPopupPresenter;
    protected FileUploadPopupPresenter fileUploadPopupPresenter;
    protected EventBus eventBus;
    protected List<HandlerRegistration> handlerRegistrationList = new ArrayList<HandlerRegistration>();
    protected Event<NotificationEvent> notificationEvent;
    protected ScenarioSimulationEditorPresenter scenarioSimulationEditorPresenter;
    protected ScenarioCommandRegistryManager scenarioCommandRegistryManager;
    protected ScenarioCommandManager scenarioCommandManager;
    protected ScenarioSimulationContext context;

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
        this.registerHandlers();
    }

    public void setDeletePopupPresenter(DeletePopupPresenter deletePopupPresenter) {
        this.deletePopupPresenter = deletePopupPresenter;
    }

    public void setPreserveDeletePopupPresenter(PreserveDeletePopupPresenter preserveDeletePopupPresenter) {
        this.preserveDeletePopupPresenter = preserveDeletePopupPresenter;
    }

    public void setConfirmPopupPresenter(ConfirmPopupPresenter confirmPopupPresenter) {
        this.confirmPopupPresenter = confirmPopupPresenter;
    }

    public void setFileUploadPopupPresenter(FileUploadPopupPresenter fileUploadPopupPresenter) {
        this.fileUploadPopupPresenter = fileUploadPopupPresenter;
    }

    public void setNotificationEvent(Event<NotificationEvent> notificationEvent) {
        this.notificationEvent = notificationEvent;
    }

    public void setScenarioSimulationPresenter(ScenarioSimulationEditorPresenter scenarioSimulationEditorPresenter) {
        this.scenarioSimulationEditorPresenter = scenarioSimulationEditorPresenter;
    }

    public void setScenarioCommandRegistryManager(ScenarioCommandRegistryManager scenarioCommandRegistryManager) {
        this.scenarioCommandRegistryManager = scenarioCommandRegistryManager;
    }

    public void setScenarioCommandManager(ScenarioCommandManager scenarioCommandManager) {
        this.scenarioCommandManager = scenarioCommandManager;
    }

    public void setContext(ScenarioSimulationContext context) {
        this.context = context;
    }

    @PreDestroy
    public void unregisterHandlers() {
        this.handlerRegistrationList.forEach(com.google.web.bindery.event.shared.HandlerRegistration::removeHandler);
    }

    @Override
    public void onEvent(AppendColumnEvent event) {
        this.context.getStatus().setColumnId(String.valueOf(new Date().getTime()));
        this.context.getStatus().setColumnGroup(event.getColumnGroup());
        this.commonExecution(new AppendColumnCommand(event.getGridWidget()), true);
    }

    @Override
    public void onEvent(AppendRowEvent event) {
        this.commonExecution(new AppendRowCommand(event.getGridWidget()), true);
    }

    @Override
    public void onEvent(DeleteColumnEvent event) {
        this.context.getStatus().setColumnIndex(event.getColumnIndex());
        this.context.getStatus().setColumnGroup(event.getColumnGroup());
        this.context.getStatus().setDisable(true);
        this.context.getStatus().setOpenDock(false);
        this.context.getStatus().setAsProperty(event.isAsProperty());
        this.commonExecution(new DeleteColumnCommand(event.getGridWidget()), true);
    }

    @Override
    public void onEvent(DeleteRowEvent event) {
        this.context.getStatus().setRowIndex(event.getRowIndex());
        this.commonExecution(new DeleteRowCommand(event.getGridWidget()), true);
    }

    @Override
    public void onEvent(DisableTestToolsEvent event) {
        this.commonExecution(new DisableTestToolsCommand(), false);
    }

    @Override
    public void onEvent(DuplicateInstanceEvent event) {
        this.context.getStatus().setColumnId(String.valueOf(new Date().getTime()));
        this.context.getStatus().setColumnIndex(event.getColumnIndex());
        this.context.getStatus().setRight(true);
        this.context.getStatus().setAsProperty(false);
        this.context.getStatus().setFullPackage(((ScenarioGridColumn)this.context.getAbstractScesimGridModelByGridWidget(event.getGridWidget()).getSelectedColumn()).getFactIdentifier().getPackageWithoutClassName());
        this.commonExecution(new DuplicateInstanceCommand(event.getGridWidget()), true);
    }

    @Override
    public void onEvent(DuplicateRowEvent event) {
        this.context.getStatus().setRowIndex(event.getRowIndex());
        this.commonExecution(new DuplicateRowCommand(event.getGridWidget()), true);
    }

    @Override
    public void onEvent(EnableTestToolsEvent event) {
        this.context.getStatus().setFilterTerm(event.getFilterTerm());
        this.context.getStatus().setPropertyNameElements(event.getPropertyNameElements());
        this.context.getStatus().setNotEqualsSearch(event.isNotEqualsSearch());
        this.commonExecution(new EnableTestToolsCommand(), false);
    }

    @Override
    public void onEvent(ImportEvent event) {
        Command okImportCommand = () -> {
            ImportCommand importCommand = new ImportCommand(event.getGridWidget(), this.fileUploadPopupPresenter.getFileContents());
            this.commonExecution(importCommand, false);
        };
        this.fileUploadPopupPresenter.show(Collections.singletonList(ImportExportType.CSV.getExtension()), ScenarioSimulationEditorConstants.INSTANCE.selectImportFile(), ScenarioSimulationEditorConstants.INSTANCE.uploadWarning(), ScenarioSimulationEditorConstants.INSTANCE.importLabel(), okImportCommand);
    }

    @Override
    public void onEvent(InsertColumnEvent event) {
        this.context.getStatus().setColumnId(String.valueOf(new Date().getTime()));
        this.context.getStatus().setColumnIndex(event.getColumnIndex());
        this.context.getStatus().setRight(event.isRight());
        this.context.getStatus().setAsProperty(event.isAsProperty());
        this.commonExecution(new InsertColumnCommand(event.getGridWidget()), true);
    }

    @Override
    public void onEvent(InsertRowEvent event) {
        this.context.getStatus().setRowIndex(event.getRowIndex());
        this.commonExecution(new InsertRowCommand(event.getGridWidget()), true);
    }

    @Override
    public void onEvent(PrependColumnEvent event) {
        this.context.getStatus().setColumnId(String.valueOf(new Date().getTime()));
        this.context.getStatus().setColumnGroup(event.getColumnGroup());
        this.commonExecution(new PrependColumnCommand(event.getGridWidget()), true);
    }

    @Override
    public void onEvent(PrependRowEvent event) {
        this.commonExecution(new PrependRowCommand(event.getGridWidget()), true);
    }

    @Override
    public void onEvent(RedoEvent event) {
        CommandResult<ScenarioSimulationViolation> status = this.scenarioCommandRegistryManager.redo(this.context);
        if (Objects.equals(CommandResult.Type.ERROR, status.getType())) {
            this.commonNotifyError(status, ScenarioSimulationEditorConstants.INSTANCE.redo());
        }
    }

    @Override
    public void onEvent(ReloadTestToolsEvent event) {
        this.context.getStatus().setDisable(event.isDisable());
        this.context.getStatus().setOpenDock(event.isOpenDock());
        this.commonExecution(new ReloadTestToolsCommand(), false);
    }

    @Override
    public void onEvent(RunSingleScenarioEvent event) {
        this.context.getStatus().setRowIndex(event.getRowIndex());
        this.commonExecution(new RunSingleScenarioCommand(), false);
    }

    @Override
    public void onEvent(ScenarioGridReloadEvent event) {
        this.context.getScenarioGridPanelByGridWidget(event.getGridWidget()).onResize();
    }

    @Override
    public void onEvent(ScenarioNotificationEvent event) {
        this.notificationEvent.fire((Object)new NotificationEvent(event.getMessage(), event.getNotificationType()).setAutoHide(event.isAutoHide()));
    }

    @Override
    public void onEvent(SetGridCellValueEvent event) {
        this.context.getStatus().setRowIndex(event.getRowIndex());
        this.context.getStatus().setColumnIndex(event.getColumnIndex());
        this.context.getStatus().setGridCellValue(event.getCellValue());
        this.commonExecution(new SetGridCellValueCommand(event.getGridWidget()), false);
    }

    @Override
    public void onEvent(SetHeaderCellValueEvent event) {
        this.context.getStatus().setRowIndex(event.getRowIndex());
        this.context.getStatus().setColumnIndex(event.getColumnIndex());
        this.context.getStatus().setHeaderCellValue(event.getHeaderCellValue());
        this.commonExecution(new SetHeaderCellValueCommand(event.getGridWidget(), event.isInstanceHeader(), event.isPropertyHeader()), false);
    }

    @Override
    public void onEvent(SetInstanceHeaderEvent event) {
        if (this.context.getAbstractScesimGridModelByGridWidget(event.getGridWidget()).isSameInstanceType(event.getClassName())) {
            return;
        }
        this.context.getStatus().setFullPackage(event.getFullPackage());
        this.context.getStatus().setClassName(event.getClassName());
        if (((ScenarioGridColumn)this.context.getAbstractScesimGridModelByGridWidget(event.getGridWidget()).getSelectedColumn()).isInstanceAssigned()) {
            Command okPreserveCommand = () -> this.commonExecution(new SetInstanceHeaderCommand(event.getGridWidget()), true);
            this.deletePopupPresenter.show(ScenarioSimulationEditorConstants.INSTANCE.changeTypeMainTitle(), ScenarioSimulationEditorConstants.INSTANCE.changeTypeMainQuestion(), ScenarioSimulationEditorConstants.INSTANCE.changeTypeText1(), ScenarioSimulationEditorConstants.INSTANCE.changeTypeTextQuestion(), ScenarioSimulationEditorConstants.INSTANCE.changeTypeTextDanger(), ScenarioSimulationEditorConstants.INSTANCE.changeType(), okPreserveCommand);
        } else {
            this.commonExecution(new SetInstanceHeaderCommand(event.getGridWidget()), true);
        }
    }

    @Override
    public void onEvent(SetPropertyHeaderEvent event) {
        if (this.context.getAbstractScesimGridModelByGridWidget(event.getGridWidget()).getSelectedColumn() == null) {
            return;
        }
        if (this.context.getAbstractScesimGridModelByGridWidget(event.getGridWidget()).isAlreadyAssignedProperty(event.getPropertyNameElements())) {
            String value = Objects.equals(FactMappingValueType.EXPRESSION, event.getFactMappingValueType()) ? "expression" : String.join((CharSequence)".", event.getPropertyNameElements());
            this.onEvent(new ScenarioNotificationEvent("Property \"" + value + "\" already assigned", NotificationEvent.NotificationType.ERROR));
            return;
        }
        this.context.getStatus().setFullPackage(event.getFullPackage());
        this.context.getStatus().setClassName(event.getFactType());
        this.context.getStatus().setPropertyNameElements(event.getPropertyNameElements());
        this.context.getStatus().setValueClassName(event.getValueClassName());
        this.context.getStatus().setImportPrefix(event.getImportPrefix());
        if (this.isSameFactProperty(event.getGridWidget(), event.getPropertyNameElements()) && this.isSameSelectedColumnType(event.getGridWidget(), event.getValueClassName())) {
            return;
        }
        if (this.isSelectedColumnEmpty(event.getGridWidget())) {
            this.commonExecution(new SetPropertyHeaderCommand(event.getGridWidget(), event.getFactMappingValueType()), true);
        } else if (!this.isSameFactProperty(event.getGridWidget(), event.getPropertyNameElements()) && !this.isSameSelectedColumnType(event.getGridWidget(), event.getValueClassName())) {
            this.showDeletePopup(event);
        } else {
            this.showPreserveDeletePopup(event);
        }
    }

    private boolean isSelectedColumnEmpty(GridWidget gridWidget) {
        return this.context.getAbstractScesimGridModelByGridWidget(gridWidget).isSelectedColumnEmpty();
    }

    private boolean isSameFactProperty(GridWidget gridWidget, List<String> propertyNameElements) {
        return this.context.getAbstractScesimGridModelByGridWidget(gridWidget).isSameSelectedColumnProperty(propertyNameElements);
    }

    private boolean isSameSelectedColumnType(GridWidget gridWidget, String valueTypeName) {
        return this.context.getAbstractScesimGridModelByGridWidget(gridWidget).isSameSelectedColumnType(valueTypeName);
    }

    private void showDeletePopup(SetPropertyHeaderEvent event) {
        Command okPreserveCommand = () -> {
            this.context.getStatus().setKeepData(false);
            this.commonExecution(new SetPropertyHeaderCommand(event.getGridWidget(), event.getFactMappingValueType()), true);
        };
        this.deletePopupPresenter.show(ScenarioSimulationEditorConstants.INSTANCE.deleteScenarioMainTitle(), ScenarioSimulationEditorConstants.INSTANCE.deleteScenarioMainQuestion(), ScenarioSimulationEditorConstants.INSTANCE.deleteScenarioText1(), ScenarioSimulationEditorConstants.INSTANCE.deleteScenarioTextQuestion(), null, ScenarioSimulationEditorConstants.INSTANCE.deleteValues(), okPreserveCommand);
    }

    private void showPreserveDeletePopup(SetPropertyHeaderEvent event) {
        Command okDeleteCommand = () -> {
            this.context.getStatus().setKeepData(false);
            this.commonExecution(new SetPropertyHeaderCommand(event.getGridWidget(), event.getFactMappingValueType()), true);
        };
        Command okPreserveCommand = () -> {
            this.context.getStatus().setKeepData(true);
            this.commonExecution(new SetPropertyHeaderCommand(event.getGridWidget(), event.getFactMappingValueType()), true);
        };
        this.preserveDeletePopupPresenter.show(ScenarioSimulationEditorConstants.INSTANCE.preserveDeleteScenarioMainTitle(), ScenarioSimulationEditorConstants.INSTANCE.preserveDeleteScenarioMainQuestion(), ScenarioSimulationEditorConstants.INSTANCE.preserveDeleteScenarioText1(), ScenarioSimulationEditorConstants.INSTANCE.preserveDeleteScenarioTextQuestion(), ScenarioSimulationEditorConstants.INSTANCE.preserveDeleteScenarioTextOption1(), ScenarioSimulationEditorConstants.INSTANCE.preserveDeleteScenarioTextOption2(), ScenarioSimulationEditorConstants.INSTANCE.preserveValues(), ScenarioSimulationEditorConstants.INSTANCE.deleteValues(), okPreserveCommand, okDeleteCommand);
    }

    @Override
    public void onEvent(UndoEvent event) {
        CommandResult<ScenarioSimulationViolation> status = this.scenarioCommandRegistryManager.undo(this.context);
        if (Objects.equals(CommandResult.Type.ERROR, status.getType())) {
            this.commonNotifyError(status, ScenarioSimulationEditorConstants.INSTANCE.undo());
        }
    }

    @Override
    public void onEvent(UnsupportedDMNEvent event) {
        this.confirmPopupPresenter.show("Unsupported DMN asset", event.getMessage());
    }

    @Override
    public void onEvent(UpdateSettingsDataEvent updateSettingsDataEvent) {
        if (updateSettingsDataEvent.getSettingsValueChanged().test(this.context.getScenarioSimulationModel().getSettings())) {
            this.commonExecution(new UpdateSettingsDataCommand(updateSettingsDataEvent.getSettingsChangeToApply(), updateSettingsDataEvent.isDmnPathChanged()), false);
            this.scenarioSimulationEditorPresenter.unpublishTestResultsAlerts();
        }
    }

    @Override
    public void onEvent(ValidateSimulationEvent event) {
        this.scenarioSimulationEditorPresenter.validateSimulation();
    }

    protected void commonExecution(AbstractScenarioSimulationCommand command, boolean focusGridAfterExecution) {
        Optional<AbstractScesimGridModel> selectedScenarioGridModel = this.context.getSelectedScenarioGridModel();
        Optional<GridWidget> gridWidget = selectedScenarioGridModel.isPresent() ? Optional.of(selectedScenarioGridModel.get().getGridWidget()) : Optional.empty();
        gridWidget.ifPresent(grd -> this.context.getStatus().setCurrentGrid((GridWidget)((Object)grd)));
        CommandResult status = this.scenarioCommandManager.execute(this.context, (org.kie.workbench.common.command.client.Command)command);
        if (Objects.equals(CommandResult.Type.ERROR, status.getType())) {
            String operation = "Command " + ((Object)((Object)command)).getClass().getSimpleName() + " failure";
            this.commonNotifyError((CommandResult<ScenarioSimulationViolation>)status, operation);
        } else if (Objects.equals(CommandResultBuilder.SUCCESS, status) && command instanceof AbstractScenarioSimulationUndoableCommand) {
            this.scenarioCommandRegistryManager.register(this.context, (AbstractScenarioSimulationUndoableCommand)command);
            if (focusGridAfterExecution && gridWidget.isPresent()) {
                this.context.getScenarioGridPanelByGridWidget((GridWidget)((Object)gridWidget.get())).setFocus(true);
            }
        }
    }

    protected void commonNotifyError(CommandResult<ScenarioSimulationViolation> status, String operation) {
        String violations = StreamSupport.stream(status.getViolations().spliterator(), false).map(ScenarioSimulationViolation::getMessage).collect(Collectors.joining("\r\n"));
        String message = operation + ": " + status.getType() + "\r\n" + violations;
        this.notificationEvent.fire((Object)new NotificationEvent(message, NotificationEvent.NotificationType.ERROR));
    }

    protected void registerHandlers() {
        this.handlerRegistrationList.add(this.eventBus.addHandler(AppendColumnEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(AppendRowEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(DeleteColumnEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(DeleteRowEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(DisableTestToolsEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(DuplicateInstanceEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(DuplicateRowEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(EnableTestToolsEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(ImportEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(InsertColumnEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(InsertRowEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(PrependColumnEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(PrependRowEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(RedoEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(ReloadTestToolsEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(RunSingleScenarioEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(ScenarioGridReloadEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(ScenarioNotificationEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(SetGridCellValueEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(SetHeaderCellValueEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(SetInstanceHeaderEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(SetPropertyHeaderEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(UndoEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(UnsupportedDMNEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(UpdateSettingsDataEvent.TYPE, (EventHandler)this));
        this.handlerRegistrationList.add(this.eventBus.addHandler(ValidateSimulationEvent.TYPE, (EventHandler)this));
    }
}

