/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.client.handlers.TitledAttachmentFileWidget;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.Radio;

public class SourceTypeSelector
extends VerticalPanel
implements ValueChangeHandler<Boolean> {
    protected static final String SOURCE_TYPE = "SOURCE_TYPE";
    protected final TitledAttachmentFileWidget uploadWidget;
    protected final List<Radio> radioButtonList = new ArrayList<Radio>();

    public SourceTypeSelector(TitledAttachmentFileWidget uploadWidget) {
        this.uploadWidget = uploadWidget;
        this.addRadioButtons();
    }

    public void onValueChange(ValueChangeEvent<Boolean> event) {
        boolean dmnSelected = this.isDMNSelected();
        this.uploadWidget.setVisible(dmnSelected);
        if (dmnSelected) {
            this.uploadWidget.updateAssetList();
        }
    }

    public boolean validate() {
        if (this.isDMNSelected()) {
            return this.uploadWidget.validate();
        }
        return true;
    }

    public boolean isDMNSelected() {
        return this.radioButtonList.stream().filter(CheckBox::getValue).anyMatch(radioButton -> radioButton.getText().equalsIgnoreCase(ScenarioSimulationModel.Type.DMN.name()));
    }

    public ScenarioSimulationModel.Type getSelectedType() {
        return this.radioButtonList.stream().filter(CheckBox::getValue).findFirst().map(selectedText -> ScenarioSimulationModel.Type.valueOf((String)selectedText.getText())).orElse(ScenarioSimulationModel.Type.RULE);
    }

    protected void addRadioButtons() {
        boolean first = true;
        this.radioButtonList.clear();
        for (ScenarioSimulationModel.Type sourceType : ScenarioSimulationModel.Type.values()) {
            Radio radioButton = new Radio(SOURCE_TYPE);
            radioButton.setText(sourceType.name());
            radioButton.setValue(Boolean.valueOf(first));
            radioButton.addValueChangeHandler((ValueChangeHandler)this);
            first = false;
            this.radioButtonList.add(radioButton);
            this.add((Widget)radioButton);
        }
        this.uploadWidget.setVisible(this.isDMNSelected());
    }
}

