/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.SettingsScenarioSimulationDropdown;
import org.drools.workbench.screens.scenariosimulation.client.events.UpdateSettingsDataEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ValidateSimulationEvent;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractSubDockPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.mvp.Command;

@ApplicationScoped
@WorkbenchScreen(identifier="org.drools.scenariosimulation.Settings", preferredWidth=300)
public class SettingsPresenter
extends AbstractSubDockPresenter<SettingsView>
implements SettingsView.Presenter {
    public static final int DEFAULT_PREFERRED_WIDHT = 300;
    public static final String IDENTIFIER = "org.drools.scenariosimulation.Settings";
    protected EventBus eventBus;
    protected Command saveCommand;
    protected SettingsScenarioSimulationDropdown settingsScenarioSimulationDropdown;

    public SettingsPresenter() {
        this.title = ScenarioSimulationEditorConstants.INSTANCE.settings();
    }

    @Inject
    public SettingsPresenter(@Named(value="SettingsDropdown") SettingsScenarioSimulationDropdown settingsScenarioSimulationDropdown, SettingsView view) {
        super(view);
        this.title = ScenarioSimulationEditorConstants.INSTANCE.settings();
        this.settingsScenarioSimulationDropdown = settingsScenarioSimulationDropdown;
    }

    @PostConstruct
    public void init() {
        ((SettingsView)this.view).getSkipFromBuildLabel().setInnerText(ScenarioSimulationEditorConstants.INSTANCE.skipSimulation());
        ((SettingsView)this.view).setupDropdown((Element)this.settingsScenarioSimulationDropdown.asWidget().asWidget().getElement());
        this.settingsScenarioSimulationDropdown.init();
    }

    @Override
    public void setScenarioType(ScenarioSimulationModel.Type scenarioType, Settings settings, String fileName) {
        ((SettingsView)this.view).getScenarioType().setInnerText(scenarioType.name());
        ((SettingsView)this.view).getFileName().setValue(fileName);
        ((SettingsView)this.view).getSkipFromBuild().setChecked(settings.isSkipFromBuild());
        switch (scenarioType) {
            case RULE: {
                this.setRuleSettings(settings);
                break;
            }
            case DMN: {
                this.setDMNSettings(settings);
                break;
            }
        }
    }

    @Override
    public void reset() {
        ((SettingsView)this.view).reset();
        this.settingsScenarioSimulationDropdown.clear();
    }

    @Override
    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public SettingsView getView() {
        return (SettingsView)this.view;
    }

    protected void setRuleSettings(Settings settings) {
        ((SettingsView)this.view).getDmnSettings().getStyle().setDisplay(Style.Display.NONE);
        ((SettingsView)this.view).getRuleSettings().getStyle().setDisplay(Style.Display.INLINE);
        this.updateRuleSettings(settings);
    }

    protected void updateRuleSettings(Settings settings) {
        ((SettingsView)this.view).getDmoSession().setValue(Optional.ofNullable(settings.getDmoSession()).orElse(""));
        ((SettingsView)this.view).getRuleFlowGroup().setValue(Optional.ofNullable(settings.getRuleFlowGroup()).orElse(""));
        ((SettingsView)this.view).getStateless().setChecked(settings.isStateless());
    }

    protected void setDMNSettings(Settings settings) {
        ((SettingsView)this.view).getRuleSettings().getStyle().setDisplay(Style.Display.NONE);
        ((SettingsView)this.view).getDmnSettings().getStyle().setDisplay(Style.Display.INLINE);
        this.settingsScenarioSimulationDropdown.registerOnMissingValueHandler(() -> this.setDmnErrorPath(settings.getDmnFilePath()));
        this.settingsScenarioSimulationDropdown.registerOnChangeHandler(this::validateSimulation);
        this.updateDMNSettings(settings);
    }

    protected void updateDMNSettings(Settings settings) {
        ((SettingsView)this.view).getDmnName().setValue(Optional.ofNullable(settings.getDmnName()).orElse(""));
        ((SettingsView)this.view).getDmnNamespace().setValue(Optional.ofNullable(settings.getDmnNamespace()).orElse(""));
        ((SettingsView)this.view).getDmnFilePathErrorLabel().getStyle().setDisplay(Style.Display.NONE);
        ((SettingsView)this.view).getDmnFilePathErrorLabel().setInnerText("");
        this.settingsScenarioSimulationDropdown.loadAssets(settings.getDmnFilePath());
    }

    @Override
    public void syncDmoSession() {
        String dmoSession = this.getCleanValue(() -> ((SettingsView)this.view).getDmoSession().getValue());
        this.eventBus.fireEvent((GwtEvent)new UpdateSettingsDataEvent(settingsToUpdate -> settingsToUpdate.setDmoSession(dmoSession), settingsToCheck -> !Objects.equals(settingsToCheck.getDmoSession(), dmoSession)));
    }

    @Override
    public void syncRuleFlowGroup() {
        String ruleFlow = this.getCleanValue(() -> ((SettingsView)this.view).getRuleFlowGroup().getValue());
        this.eventBus.fireEvent((GwtEvent)new UpdateSettingsDataEvent(settingsToUpdate -> settingsToUpdate.setRuleFlowGroup(ruleFlow), settingsToCheck -> !Objects.equals(settingsToCheck.getRuleFlowGroup(), ruleFlow)));
    }

    @Override
    public void syncStateless() {
        boolean isStateless = ((SettingsView)this.view).getStateless().isChecked();
        this.eventBus.fireEvent((GwtEvent)new UpdateSettingsDataEvent(settingsToUpdate -> settingsToUpdate.setStateless(isStateless)));
    }

    @Override
    public void syncDmnFilePath() {
        String dmnFilePath = this.getCleanValue(() -> this.settingsScenarioSimulationDropdown.getValue().map(KieAssetsDropdownItem::getValue).orElse(""));
        this.eventBus.fireEvent((GwtEvent)new UpdateSettingsDataEvent(settingsToUpdate -> settingsToUpdate.setDmnFilePath(dmnFilePath), settingsToCheck -> !Objects.equals(settingsToCheck.getDmnFilePath(), dmnFilePath)));
    }

    @Override
    public void syncSkipFromBuild() {
        boolean isSkipFromBuild = ((SettingsView)this.view).getSkipFromBuild().isChecked();
        this.eventBus.fireEvent((GwtEvent)new UpdateSettingsDataEvent(settingsToUpdate -> settingsToUpdate.setSkipFromBuild(isSkipFromBuild)));
    }

    @Override
    public void updateSettingsData(Settings settings) {
        if (!this.isSettingTypeValid(settings.getType())) {
            throw new IllegalStateException("Trying to update a wrong settings set for this Test Scenario, which is not of " + settings.getType() + " type.");
        }
        ((SettingsView)this.view).getSkipFromBuild().setChecked(settings.isSkipFromBuild());
        if (ScenarioSimulationModel.Type.RULE.equals((Object)settings.getType())) {
            this.setRuleSettings(settings);
        } else {
            this.setDMNSettings(settings);
        }
    }

    private boolean isSettingTypeValid(ScenarioSimulationModel.Type type) {
        return ScenarioSimulationModel.Type.DMN.equals((Object)type) && Style.Display.INLINE.getCssName().equals(((SettingsView)this.view).getDmnSettings().getStyle().getDisplay()) || ScenarioSimulationModel.Type.RULE.equals((Object)type) && Style.Display.INLINE.getCssName().equals(((SettingsView)this.view).getRuleSettings().getStyle().getDisplay());
    }

    protected void setDmnErrorPath(String requiredDMNFilePath) {
        ((SettingsView)this.view).getDmnFilePathErrorLabel().getStyle().setDisplay(Style.Display.INLINE);
        ((SettingsView)this.view).getDmnFilePathErrorLabel().setInnerText(ScenarioSimulationEditorConstants.INSTANCE.dmnPathErrorLabel(requiredDMNFilePath));
    }

    protected void validateSimulation() {
        boolean isValid;
        Optional value = this.settingsScenarioSimulationDropdown.getValue();
        String selectedPath = value.map(KieAssetsDropdownItem::getValue).orElse(null);
        boolean bl = isValid = selectedPath != null && !selectedPath.isEmpty();
        if (!isValid) {
            ((SettingsView)this.view).getDmnFilePathErrorLabel().getStyle().setDisplay(Style.Display.INLINE);
            ((SettingsView)this.view).getDmnFilePathErrorLabel().setInnerText(ScenarioSimulationEditorConstants.INSTANCE.chooseValidDMNAsset());
        } else {
            this.syncDmnFilePath();
            ((SettingsView)this.view).getDmnFilePathErrorLabel().getStyle().setDisplay(Style.Display.NONE);
            ((SettingsView)this.view).getDmnFilePathErrorLabel().setInnerText("");
            this.eventBus.fireEvent((GwtEvent)new ValidateSimulationEvent());
        }
    }

    private String getCleanValue(Supplier<String> supplier) {
        String rawValue = supplier.get();
        return "".equals(rawValue) ? null : rawValue;
    }
}

