/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import elemental2.dom.DomGlobal;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.BackgroundData;
import org.drools.scenariosimulation.api.model.BackgroundDataWithIndex;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValueStatus;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorWrapper;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDMODataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.events.ImportEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.RedoEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioNotificationEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.UndoEvent;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioMenuItemFactory;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationDocksHandler;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationHasBusyIndicatorDefaultErrorCallback;
import org.drools.workbench.screens.scenariosimulation.client.popup.ConfirmPopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popup.CustomBusyPopup;
import org.drools.workbench.screens.scenariosimulation.client.producers.AbstractScenarioSimulationProducer;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridWidget;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.drools.workbench.screens.scenariosimulation.model.SimulationRunResult;
import org.drools.workbench.screens.scenariosimulation.service.ImportExportType;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.enterprise.client.jaxrs.MarshallingWrapper;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.docks.UberfireDocksInteractionEvent;
import org.uberfire.ext.editor.commons.client.file.exports.TextContent;
import org.uberfire.ext.editor.commons.client.file.exports.TextFileExport;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

@Dependent
public class ScenarioSimulationEditorPresenter {
    public static final String IDENTIFIER = "ScenarioSimulationEditor";
    private static final AtomicLong SCENARIO_PRESENTER_COUNTER = new AtomicLong();
    protected String packageName = "";
    protected ObservablePath path;
    protected EventBus eventBus;
    protected ScenarioGridWidget scenarioMainGridWidget;
    protected ScenarioGridWidget scenarioBackgroundGridWidget;
    protected PlaceManager placeManager;
    protected DataManagementStrategy dataManagementStrategy;
    protected ScenarioSimulationContext context;
    protected ScenarioSimulationModel model;
    protected long scenarioPresenterId;
    protected MenuItem undoMenuItem;
    protected MenuItem redoMenuItem;
    protected MenuItem runScenarioMenuItem;
    protected MenuItem exportToCSVMenuItem;
    protected MenuItem importMenuItem;
    protected MenuItem downloadMenuItem;
    protected ScenarioSimulationEditorWrapper scenarioSimulationEditorWrapper;
    private ScenarioSimulationResourceType type;
    private ScenarioSimulationView view;
    private Command populateTestToolsCommand;
    private TextFileExport textFileExport;
    private ConfirmPopupPresenter confirmPopupPresenter;
    private AbstractScenarioSimulationDocksHandler abstractScenarioSimulationDocksHandler;

    public ScenarioSimulationEditorPresenter() {
    }

    @Inject
    public ScenarioSimulationEditorPresenter(AbstractScenarioSimulationProducer abstractScenarioSimulationProducer, ScenarioSimulationResourceType type, PlaceManager placeManager, AbstractScenarioSimulationDocksHandler abstractScenarioSimulationDocksHandler, TextFileExport textFileExport, ConfirmPopupPresenter confirmPopupPresenter) {
        this.view = abstractScenarioSimulationProducer.getScenarioSimulationView();
        this.abstractScenarioSimulationDocksHandler = abstractScenarioSimulationDocksHandler;
        this.type = type;
        this.placeManager = placeManager;
        this.eventBus = abstractScenarioSimulationProducer.getEventBus();
        this.textFileExport = textFileExport;
        this.confirmPopupPresenter = confirmPopupPresenter;
        this.view.init();
        this.initMenuItems();
        abstractScenarioSimulationProducer.setScenarioSimulationEditorPresenter(this);
        this.scenarioMainGridWidget = this.view.getScenarioGridWidget();
        this.scenarioMainGridWidget.getScenarioSimulationContext().setScenarioSimulationEditorPresenter(this);
        this.scenarioBackgroundGridWidget = abstractScenarioSimulationProducer.getScenarioBackgroundGridWidget();
        this.scenarioBackgroundGridWidget.getScenarioSimulationContext().setScenarioSimulationEditorPresenter(this);
        this.populateTestToolsCommand = this.createPopulateTestToolsCommand();
        this.scenarioPresenterId = SCENARIO_PRESENTER_COUNTER.getAndIncrement();
        this.context = abstractScenarioSimulationProducer.getScenarioSimulationContext();
    }

    public void setWrapper(ScenarioSimulationEditorWrapper scenarioSimulationEditorWrapper) {
        this.scenarioSimulationEditorWrapper = scenarioSimulationEditorWrapper;
    }

    private void initMenuItems() {
        this.undoMenuItem = ScenarioMenuItemFactory.getUndoMenuItem(this::onUndo);
        this.redoMenuItem = ScenarioMenuItemFactory.getRedoMenuItem(this::onRedo);
        this.runScenarioMenuItem = ScenarioMenuItemFactory.getRunScenarioMenuItem(this::onRunScenario);
        this.exportToCSVMenuItem = ScenarioMenuItemFactory.getExportToCsvMenuItem(this::onExportToCsv);
        this.importMenuItem = ScenarioMenuItemFactory.getImportMenuItem(this::showImportDialog);
    }

    public void setPath(ObservablePath path) {
        this.path = path;
    }

    public ObservablePath getPath() {
        return this.path;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void onClose() {
        this.scenarioMainGridWidget.unregister();
        this.scenarioBackgroundGridWidget.unregister();
    }

    public void showDocks(PlaceStatus status) {
        this.abstractScenarioSimulationDocksHandler.addDocks();
        this.abstractScenarioSimulationDocksHandler.setScesimEditorId(String.valueOf(this.scenarioPresenterId));
        if (!PlaceStatus.OPEN.equals((Object)status)) {
            this.expandToolsDock();
        }
        this.registerTestToolsCallback();
        this.resetDocks();
        this.populateRightDocks("org.drools.scenariosimulation.TestTools");
    }

    public void hideDocks() {
        this.abstractScenarioSimulationDocksHandler.removeDocks();
        this.scenarioMainGridWidget.clearSelections();
        this.scenarioBackgroundGridWidget.clearSelections();
        this.unRegisterTestToolsCallback();
        this.clearTestToolsStatus();
    }

    public void onUberfireDocksInteractionEvent(@Observes UberfireDocksInteractionEvent uberfireDocksInteractionEvent) {
        if (this.isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEvent) && !"org.drools.scenariosimulation.TestTools".equals(uberfireDocksInteractionEvent.getTargetDock().getIdentifier())) {
            this.populateRightDocks(uberfireDocksInteractionEvent.getTargetDock().getIdentifier());
        }
    }

    public void expandToolsDock() {
        this.abstractScenarioSimulationDocksHandler.expandToolsDock();
    }

    public ScenarioSimulationView getView() {
        return this.view;
    }

    public ScenarioSimulationModel getModel() {
        return this.model;
    }

    public Command getPopulateTestToolsCommand() {
        return this.populateTestToolsCommand;
    }

    public void reloadTestTools(boolean disable) {
        this.populateRightDocks("org.drools.scenariosimulation.TestTools");
        if (disable) {
            this.abstractScenarioSimulationDocksHandler.getTestToolsPresenter().ifPresent(TestToolsView.Presenter::onDisableEditorTab);
        }
    }

    public void onRunScenario() {
        List<Integer> indexes = IntStream.range(0, this.context.getStatus().getSimulation().getUnmodifiableData().size()).boxed().collect(Collectors.toList());
        this.onRunScenario(indexes);
    }

    public void onRunScenario(List<Integer> indexOfScenarioToRun) {
        this.scenarioMainGridWidget.resetErrors();
        this.scenarioBackgroundGridWidget.resetErrors();
        this.model.setSimulation(this.scenarioMainGridWidget.getScenarioSimulationContext().getStatus().getSimulation());
        this.model.setBackground(this.scenarioMainGridWidget.getScenarioSimulationContext().getStatus().getBackground());
        Simulation simulation = this.model.getSimulation();
        List<ScenarioWithIndex> toRun = simulation.getScenarioWithIndex().stream().filter(elem -> indexOfScenarioToRun.contains(elem.getIndex() - 1)).collect(Collectors.toList());
        this.view.showBusyIndicator(ScenarioSimulationEditorConstants.INSTANCE.running());
        this.scenarioSimulationEditorWrapper.onRunScenario(this.getRefreshModelCallback(), new ScenarioSimulationHasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view), simulation.getScesimModelDescriptor(), this.context.getSettings(), toRun, this.model.getBackground());
    }

    public void onUndo() {
        this.eventBus.fireEvent((GwtEvent)new UndoEvent());
    }

    public void onRedo() {
        this.eventBus.fireEvent((GwtEvent)new RedoEvent());
    }

    public void setUndoButtonEnabledStatus(boolean enabled) {
        this.undoMenuItem.setEnabled(enabled);
    }

    public void setRedoButtonEnabledStatus(boolean enabled) {
        this.redoMenuItem.setEnabled(enabled);
    }

    public void setItemMenuEnabled(boolean enabled) {
        this.runScenarioMenuItem.setEnabled(enabled);
        this.importMenuItem.setEnabled(enabled);
        this.exportToCSVMenuItem.setEnabled(enabled);
        if (this.downloadMenuItem != null) {
            this.downloadMenuItem.setEnabled(enabled);
        }
    }

    public void addDownloadMenuItem(FileMenuBuilder fileMenuBuilder, Supplier<Path> pathSupplier) {
        this.downloadMenuItem = ScenarioMenuItemFactory.getDownloadMenuItem(() -> this.onDownload(pathSupplier));
        fileMenuBuilder.addNewTopLevelMenu(this.downloadMenuItem);
    }

    public DataManagementStrategy getDataManagementStrategy() {
        return this.dataManagementStrategy;
    }

    public void onImport(String fileContents, GridWidget gridWidget) {
        switch (gridWidget) {
            case SIMULATION: {
                this.scenarioSimulationEditorWrapper.onImport(fileContents, this.getImportCallBack(), this.getImportErrorCallback(), (AbstractScesimModel<? extends AbstractScesimData>)this.context.getStatus().getSimulation());
                break;
            }
            case BACKGROUND: {
                this.scenarioSimulationEditorWrapper.onImport(fileContents, this.getImportCallBack(), this.getImportErrorCallback(), (AbstractScesimModel<? extends AbstractScesimData>)this.context.getStatus().getBackground());
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal GridWidget " + (Object)((Object)gridWidget));
            }
        }
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public ScenarioSimulationContext getContext() {
        return this.context;
    }

    protected void resetDocks() {
        this.abstractScenarioSimulationDocksHandler.resetDocks();
    }

    protected boolean isUberfireDocksInteractionEventToManage(UberfireDocksInteractionEvent uberfireDocksInteractionEvent) {
        return uberfireDocksInteractionEvent.getTargetDock() != null && uberfireDocksInteractionEvent.getTargetDock().getPlaceRequest().getParameter("scesimeditorid", "").equals(String.valueOf(this.scenarioPresenterId));
    }

    protected RemoteCallback<SimulationRunResult> getRefreshModelCallback() {
        return this::refreshModelContent;
    }

    protected void refreshModelContent(SimulationRunResult newData) {
        this.view.hideBusyIndicator();
        if (this.model == null) {
            return;
        }
        Simulation simulation = this.model.getSimulation();
        for (ScenarioWithIndex scenarioWithIndex : newData.getScenarioWithIndex()) {
            int index = scenarioWithIndex.getIndex() - 1;
            simulation.replaceData(index, scenarioWithIndex.getScesimData());
        }
        this.scenarioMainGridWidget.refreshContent((AbstractScesimModel)simulation);
        this.context.getStatus().setSimulation(simulation);
        boolean hasBackgroundError = false;
        Background background = this.model.getBackground();
        for (BackgroundDataWithIndex backgroundDataWithIndex : newData.getBackgroundDataWithIndex()) {
            int index = backgroundDataWithIndex.getIndex() - 1;
            BackgroundData scesimData = (BackgroundData)backgroundDataWithIndex.getScesimData();
            background.replaceData(index, (AbstractScesimData)scesimData);
            hasBackgroundError |= scesimData.getUnmodifiableFactMappingValues().stream().anyMatch(elem -> !FactMappingValueStatus.SUCCESS.equals((Object)elem.getStatus()));
        }
        this.scenarioBackgroundGridWidget.refreshContent((AbstractScesimModel)background);
        this.context.getStatus().setBackground(background);
        if (hasBackgroundError) {
            this.sendNotification(ScenarioSimulationEditorConstants.INSTANCE.backgroundErrorNotification(), NotificationEvent.NotificationType.ERROR);
            this.selectBackgroundTab();
        }
        this.dataManagementStrategy.setModel(this.model);
        this.abstractScenarioSimulationDocksHandler.expandTestResultsDock();
        this.scenarioSimulationEditorWrapper.onRefreshedModelContent(newData);
    }

    public void sendNotification(String text, NotificationEvent.NotificationType type) {
        this.eventBus.fireEvent((GwtEvent)new ScenarioNotificationEvent(text, type));
    }

    public void sendNotification(String text, NotificationEvent.NotificationType type, boolean autoHide) {
        this.eventBus.fireEvent((GwtEvent)new ScenarioNotificationEvent(text, type, autoHide));
    }

    protected void registerTestToolsCallback() {
        this.placeManager.registerOnOpenCallback((PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.TestTools"), this.populateTestToolsCommand);
    }

    protected void unRegisterTestToolsCallback() {
        this.placeManager.getOnOpenCallbacks((PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.TestTools")).remove(this.populateTestToolsCommand);
    }

    protected ErrorCallback<Object> getImportErrorCallback() {
        return (error, exception) -> {
            this.confirmPopupPresenter.show(ScenarioSimulationEditorConstants.INSTANCE.importErrorTitle(), ScenarioSimulationEditorConstants.INSTANCE.importFailedMessage());
            return false;
        };
    }

    public void makeMenuBar(FileMenuBuilder fileMenuBuilder) {
        fileMenuBuilder.addValidate(this.getValidateCommand());
        fileMenuBuilder.addNewTopLevelMenu(this.runScenarioMenuItem);
        fileMenuBuilder.addNewTopLevelMenu(this.undoMenuItem);
        fileMenuBuilder.addNewTopLevelMenu(this.redoMenuItem);
        fileMenuBuilder.addNewTopLevelMenu(this.exportToCSVMenuItem);
        fileMenuBuilder.addNewTopLevelMenu(this.importMenuItem);
        this.undoMenuItem.setEnabled(false);
        this.redoMenuItem.setEnabled(false);
    }

    public void addCommonActions(FileMenuBuilder fileMenuBuilder, MenuItem versionMenuItem, MenuItem alertsButtonMenuItem) {
        fileMenuBuilder.addNewTopLevelMenu(versionMenuItem).addNewTopLevelMenu(alertsButtonMenuItem);
    }

    public void loadContent() {
        CustomBusyPopup.showMessage(CommonConstants.INSTANCE.Loading());
    }

    public boolean isDirty() {
        try {
            this.scenarioMainGridWidget.resetErrors();
            int currentHashcode = MarshallingWrapper.toJSON((Object)this.model).hashCode();
            return this.scenarioSimulationEditorWrapper.getOriginalHash() != currentHashcode;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void onEditTabSelected() {
        this.setItemMenuEnabled(true);
        this.populateRightDocks("org.drools.scenariosimulation.TestTools");
        this.scenarioMainGridWidget.selectAndFocus();
        this.scenarioBackgroundGridWidget.deselectAndUnFocus();
    }

    public void onBackgroundTabSelected() {
        this.setItemMenuEnabled(true);
        this.populateRightDocks("org.drools.scenariosimulation.TestTools");
        this.scenarioBackgroundGridWidget.selectAndFocus();
        this.scenarioMainGridWidget.deselectAndUnFocus();
    }

    public void onOverviewSelected() {
        this.setItemMenuEnabled(false);
        this.scenarioMainGridWidget.deselectAndUnFocus();
        this.scenarioBackgroundGridWidget.deselectAndUnFocus();
    }

    public void onImportsTabSelected() {
        this.setItemMenuEnabled(false);
        this.scenarioMainGridWidget.deselectAndUnFocus();
        this.scenarioBackgroundGridWidget.deselectAndUnFocus();
    }

    public void validateSimulation() {
        this.scenarioSimulationEditorWrapper.validate(this.context.getStatus().getSimulation(), this.context.getSettings(), this.getValidationCallback());
    }

    public void selectSimulationTab() {
        this.scenarioSimulationEditorWrapper.selectSimulationTab();
    }

    public void selectBackgroundTab() {
        this.scenarioSimulationEditorWrapper.selectBackgroundTab();
    }

    protected void onDownload(Supplier<Path> pathSupplier) {
        String downloadURL = this.getFileDownloadURL(pathSupplier);
        this.open(downloadURL);
    }

    protected void open(String downloadURL) {
        DomGlobal.window.open((Object)downloadURL);
    }

    protected void showImportDialog() {
        this.context.getSelectedGridWidget().ifPresent(gridWidget -> this.eventBus.fireEvent((GwtEvent)new ImportEvent((GridWidget)((Object)gridWidget))));
    }

    protected void onExportToCsv() {
        this.context.getSelectedGridWidget().ifPresent(gridWidget -> this.scenarioSimulationEditorWrapper.onExportToCsv(this.getExportCallBack(), new ScenarioSimulationHasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view), this.context.getAbstractScesimModelByGridWidget((GridWidget)((Object)gridWidget))));
    }

    public RemoteCallback<String> getExportCallBack() {
        return rawResult -> {
            TextContent textContent = TextContent.create((String)rawResult);
            this.textFileExport.export((Object)textContent, this.path.getFileName() + ImportExportType.CSV.getExtension());
        };
    }

    protected RemoteCallback<AbstractScesimModel> getImportCallBack() {
        return scesimModel -> {
            this.cleanReadOnlyColumn((AbstractScesimModel)scesimModel);
            if (scesimModel instanceof Simulation) {
                this.model.setSimulation((Simulation)scesimModel);
                this.scenarioMainGridWidget.setContent((AbstractScesimModel)this.model.getSimulation(), this.context.getSettings().getType());
                this.context.getStatus().setSimulation(this.model.getSimulation());
                this.scenarioMainGridWidget.onResize();
            } else if (scesimModel instanceof Background) {
                this.model.setBackground((Background)scesimModel);
                this.scenarioBackgroundGridWidget.setContent((AbstractScesimModel)this.model.getBackground(), this.context.getSettings().getType());
                this.context.getStatus().setBackground(this.model.getBackground());
                this.scenarioBackgroundGridWidget.onResize();
            }
        };
    }

    protected Command getValidateCommand() {
        return this::validateSimulation;
    }

    protected RemoteCallback<List<FactMappingValidationError>> getValidationCallback() {
        return result -> {
            this.view.hideBusyIndicator();
            if (result != null && !result.isEmpty()) {
                StringBuilder errorMessage = new StringBuilder(ScenarioSimulationEditorConstants.INSTANCE.validationErrorMessage());
                errorMessage.append(":<br/>");
                for (FactMappingValidationError validationError : result) {
                    errorMessage.append("<b>");
                    errorMessage.append(validationError.getErrorId());
                    errorMessage.append("</b> - ");
                    errorMessage.append(validationError.getErrorMessage());
                    errorMessage.append("<br/>");
                }
                this.confirmPopupPresenter.show(ScenarioSimulationEditorConstants.INSTANCE.validationErrorTitle(), errorMessage.toString());
            } else {
                this.sendNotification(ScenarioSimulationEditorConstants.INSTANCE.validationSucceed(), NotificationEvent.NotificationType.SUCCESS);
            }
        };
    }

    public ErrorCallback<Boolean> getValidationFailedCallback() {
        return (message, exception) -> {
            CustomBusyPopup.close();
            BusyPopup.close();
            this.sendNotification(ScenarioSimulationEditorConstants.INSTANCE.validationFailedNotification(), NotificationEvent.NotificationType.ERROR);
            return false;
        };
    }

    protected void cleanReadOnlyColumn(AbstractScesimModel abstractScesimModel) {
        ScesimModelDescriptor scesimModelDescriptor = abstractScesimModel.getScesimModelDescriptor();
        for (int i = 0; i < abstractScesimModel.getUnmodifiableData().size(); ++i) {
            AbstractScesimData abstractScesimData = abstractScesimModel.getDataByIndex(i);
            for (FactMapping factMapping : scesimModelDescriptor.getUnmodifiableFactMappings()) {
                if (!this.isColumnReadOnly(factMapping)) continue;
                abstractScesimData.getFactMappingValue(factMapping.getFactIdentifier(), factMapping.getExpressionIdentifier()).ifPresent(fmv -> fmv.setRawValue(null));
            }
        }
    }

    private boolean isColumnReadOnly(FactMapping factMapping) {
        return !FactMappingType.OTHER.equals((Object)factMapping.getExpressionIdentifier().getType()) && factMapping.getExpressionElements().isEmpty();
    }

    public void populateRightDocks(String identifier) {
        if (this.dataManagementStrategy != null) {
            this.scenarioSimulationEditorWrapper.populateDocks(identifier);
        }
    }

    public void getModelSuccessCallbackMethod(DataManagementStrategy dataManagementStrategy, ScenarioSimulationModel model) {
        this.dataManagementStrategy = dataManagementStrategy;
        this.model = model;
        this.scenarioSimulationEditorWrapper.addBackgroundPage(this.scenarioBackgroundGridWidget);
        this.context.setSettings(model.getSettings());
        this.scenarioBackgroundGridWidget.setContent((AbstractScesimModel)model.getBackground(), this.context.getSettings().getType());
        this.populateRightDocks("org.drools.scenariosimulation.TestTools");
        this.populateRightDocks("org.drools.scenariosimulation.Settings");
        this.scenarioMainGridWidget.setContent((AbstractScesimModel)model.getSimulation(), this.context.getSettings().getType());
        this.context.getStatus().setSimulation(model.getSimulation());
        this.context.getStatus().setBackground(model.getBackground());
        CustomBusyPopup.close();
        this.context.getSelectedScenarioGridWidget().ifPresent(ScenarioGridWidget::selectAndFocus);
        this.getValidateCommand().execute();
    }

    public ScenarioSimulationResourceType getType() {
        return this.type;
    }

    public void setTestTools(TestToolsView.Presenter presenter) {
        this.context.setTestToolsPresenter(presenter);
        presenter.setEventBus(this.eventBus);
        GridWidget gridWidget = this.scenarioBackgroundGridWidget.isSelected() ? GridWidget.BACKGROUND : GridWidget.SIMULATION;
        this.dataManagementStrategy.populateTestTools(presenter, this.context, gridWidget);
    }

    protected void clearTestToolsStatus() {
        this.abstractScenarioSimulationDocksHandler.getTestToolsPresenter().ifPresent(TestToolsView.Presenter::onClearStatus);
    }

    public void setCheatSheet(CheatSheetView.Presenter presenter) {
        ScenarioSimulationModel.Type modelType = this.dataManagementStrategy instanceof AbstractDMODataManagementStrategy ? ScenarioSimulationModel.Type.RULE : ScenarioSimulationModel.Type.DMN;
        presenter.initCheatSheet(modelType);
    }

    public void setSettings(SettingsView.Presenter presenter) {
        ScenarioSimulationModel.Type modelType = this.dataManagementStrategy instanceof AbstractDMODataManagementStrategy ? ScenarioSimulationModel.Type.RULE : ScenarioSimulationModel.Type.DMN;
        presenter.setEventBus(this.eventBus);
        presenter.setScenarioType(modelType, this.context.getSettings(), this.path.getFileName());
    }

    public String getJsonModel(ScenarioSimulationModel model) {
        return MarshallingWrapper.toJSON((Object)model);
    }

    protected String getFileDownloadURL(Supplier<Path> pathSupplier) {
        return GWT.getModuleBaseURL() + "defaulteditor/download?path=" + pathSupplier.get().toURI();
    }

    private Command createPopulateTestToolsCommand() {
        return () -> this.populateRightDocks("org.drools.scenariosimulation.TestTools");
    }
}

