/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import java.util.Objects;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemView;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Templated
public class FieldItemViewImpl
implements FieldItemView {
    @DataField(value="fieldElement")
    protected LIElement fieldElement = Document.get().createLIElement();
    @DataField(value="fieldNameElement")
    protected SpanElement fieldNameElement = Document.get().createSpanElement();
    @DataField(value="checkElement")
    protected SpanElement checkElement = Document.get().createSpanElement();
    private FieldItemView.Presenter fieldItemPresenter;
    private String fullPath;
    private String factName;
    private String fieldName;
    private String className;

    @Override
    public void setFieldData(String fullPath, String factName, String fieldName, String className) {
        String innerHtml = "<a>" + fieldName + "</a> [" + className + "]";
        this.fieldNameElement.setInnerHTML(innerHtml);
        this.fieldNameElement.setAttribute("id", "fieldElement-" + factName + "-" + fieldName);
        this.fieldNameElement.setAttribute("fieldName", fieldName);
        this.fieldNameElement.setAttribute("className", className);
        this.fieldNameElement.setAttribute("fullPath", fullPath);
        this.factName = factName;
        this.fieldName = fieldName;
        this.className = className;
        this.fullPath = fullPath;
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    @Override
    public String getFactName() {
        return this.factName;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setPresenter(FieldItemView.Presenter fieldItemPresenter) {
        this.fieldItemPresenter = fieldItemPresenter;
    }

    @Override
    public LIElement getLIElement() {
        return this.fieldElement;
    }

    @EventHandler(value={"fieldElement"})
    public void onFieldElementClick(ClickEvent clickEvent) {
        this.onFieldElementSelected();
    }

    @Override
    public void onFieldElementSelected() {
        this.fieldElement.addClassName("selected");
        this.showCheck(true);
        this.fieldItemPresenter.onFieldElementClick(this);
    }

    @Override
    public void showCheck(boolean show) {
        if (show) {
            this.checkElement.getStyle().setDisplay(Style.Display.BLOCK);
        } else {
            this.checkElement.getStyle().setDisplay(Style.Display.NONE);
        }
    }

    @Override
    public boolean isCheckShown() {
        return !Objects.equals(Style.Display.NONE.getCssName(), this.checkElement.getStyle().getDisplay());
    }

    @Override
    public void unselect() {
        this.fieldElement.removeClassName("selected");
        this.showCheck(false);
    }

    @Override
    public void hide() {
        this.fieldElement.getStyle().setDisplay(Style.Display.NONE);
    }

    @Override
    public void show() {
        this.fieldElement.getStyle().setDisplay(Style.Display.BLOCK);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldItemViewImpl that = (FieldItemViewImpl)o;
        return Objects.equals(this.getFullPath(), that.getFullPath()) && Objects.equals(this.getFactName(), that.getFactName()) && Objects.equals(this.getFieldName(), that.getFieldName()) && Objects.equals(this.getClassName(), that.getClassName());
    }

    public int hashCode() {
        return Objects.hash(this.getFullPath(), this.getFactName(), this.getFieldName(), this.getClassName());
    }

    public String toString() {
        return "FieldItemViewImpl{fullPath='" + this.fullPath + '\'' + ", factName='" + this.factName + '\'' + ", fieldName='" + this.fieldName + '\'' + ", className='" + this.className + '\'' + '}';
    }
}

