/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.ScenarioSimulationDropdown;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationHasBusyIndicatorDefaultErrorCallback;
import org.drools.workbench.screens.scenariosimulation.client.handlers.SourceTypeSelector;
import org.drools.workbench.screens.scenariosimulation.client.handlers.TitledAttachmentFileWidget;
import org.drools.workbench.screens.scenariosimulation.client.popup.CustomBusyPopup;
import org.drools.workbench.screens.scenariosimulation.client.resources.ScenarioSimulationEditorResources;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewScenarioSimulationHandler
extends DefaultNewResourceHandler {
    protected TitledAttachmentFileWidget uploadWidget;
    protected SourceTypeSelector sourceTypeSelector;
    private Caller<ScenarioSimulationService> scenarioSimulationService;
    private ScenarioSimulationResourceType resourceType;
    private final AuthorizationManager authorizationManager;
    private final SessionInfo sessionInfo;
    private final ScenarioSimulationDropdown scenarioSimulationDropdown;

    @Inject
    public NewScenarioSimulationHandler(ScenarioSimulationResourceType resourceType, BusyIndicatorView busyIndicatorView, Event<NotificationEvent> notificationEvent, Event<NewResourceSuccessEvent> newResourceSuccessEvent, PlaceManager placeManager, Caller<ScenarioSimulationService> scenarioSimulationService, AuthorizationManager authorizationManager, SessionInfo sessionInfo, @Named(value="ScenarioDropdown") ScenarioSimulationDropdown scenarioSimulationDropdown) {
        this.resourceType = resourceType;
        this.authorizationManager = authorizationManager;
        this.sessionInfo = sessionInfo;
        this.newResourceSuccessEvent = newResourceSuccessEvent;
        this.busyIndicatorView = busyIndicatorView;
        this.scenarioSimulationService = scenarioSimulationService;
        this.placeManager = placeManager;
        this.notificationEvent = notificationEvent;
        this.scenarioSimulationDropdown = scenarioSimulationDropdown;
    }

    public String getDescription() {
        return ScenarioSimulationEditorConstants.INSTANCE.newScenarioSimulationDescription();
    }

    public IsWidget getIcon() {
        return new Image(ScenarioSimulationEditorResources.INSTANCE.images().typeScenarioSimulation());
    }

    public ResourceTypeDefinition getResourceType() {
        return this.resourceType;
    }

    public boolean canCreate() {
        return this.authorizationManager.authorize((Resource)new ResourceRef("ScenarioSimulationEditor", (ResourceType)ActivityResourceType.EDITOR), ResourceAction.READ, this.sessionInfo.getIdentity());
    }

    public Command getCommand(NewResourcePresenter newResourcePresenter) {
        return () -> this.getCommandMethod(newResourcePresenter);
    }

    public void create(Package pkg, String baseFileName, NewResourcePresenter presenter) {
        String value;
        if (!this.sourceTypeSelector.validate()) {
            return;
        }
        ScenarioSimulationModel.Type selectedType = this.sourceTypeSelector.getSelectedType();
        switch (selectedType) {
            case DMN: {
                value = this.uploadWidget.getSelectedPath();
                break;
            }
            default: {
                value = null;
            }
        }
        this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Saving());
        CustomBusyPopup.showMessage(CommonConstants.INSTANCE.Saving());
        ((ScenarioSimulationService)this.scenarioSimulationService.call(this.getSuccessCallback(presenter), (ErrorCallback)new ScenarioSimulationHasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).create(pkg.getPackageTestResourcesPath(), this.buildFileName(baseFileName, (ResourceTypeDefinition)this.resourceType), new ScenarioSimulationModel(), "", selectedType, value);
    }

    @PostConstruct
    public void setupExtensions() {
        this.uploadWidget = new TitledAttachmentFileWidget(ScenarioSimulationEditorConstants.INSTANCE.chooseDMN(), this.scenarioSimulationService, this.scenarioSimulationDropdown);
        this.sourceTypeSelector = new SourceTypeSelector(this.uploadWidget);
        this.extensions.add(Pair.newPair((Object)ScenarioSimulationEditorConstants.INSTANCE.sourceType(), (Object)((Object)this.sourceTypeSelector)));
        this.extensions.add(Pair.newPair((Object)"", (Object)((Object)this.uploadWidget)));
    }

    protected void getCommandMethod(NewResourcePresenter newResourcePresenter) {
        this.uploadWidget.clearStatus();
        newResourcePresenter.show((NewResourceHandler)this);
    }
}

