/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.workbench.screens.scenariosimulation.client.dropdown.SettingsScenarioSimulationDropdown;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractSubDockPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.mvp.Command;

@ApplicationScoped
@WorkbenchScreen(identifier="org.drools.scenariosimulation.Settings", preferredWidth=300)
public class SettingsPresenter
extends AbstractSubDockPresenter<SettingsView>
implements SettingsView.Presenter {
    public static final int DEFAULT_PREFERRED_WIDHT = 300;
    public static final String IDENTIFIER = "org.drools.scenariosimulation.Settings";
    protected Settings settings;
    protected Command saveCommand;
    protected SettingsScenarioSimulationDropdown settingsScenarioSimulationDropdown;

    public SettingsPresenter() {
        this.title = ScenarioSimulationEditorConstants.INSTANCE.settings();
    }

    @Inject
    public SettingsPresenter(@Named(value="SettingsDropdown") SettingsScenarioSimulationDropdown settingsScenarioSimulationDropdown, SettingsView view) {
        super(view);
        this.title = ScenarioSimulationEditorConstants.INSTANCE.settings();
        this.settingsScenarioSimulationDropdown = settingsScenarioSimulationDropdown;
    }

    @PostConstruct
    public void init() {
        ((SettingsView)this.view).getSkipFromBuildLabel().setInnerText(ScenarioSimulationEditorConstants.INSTANCE.skipSimulation());
        ((SettingsView)this.view).setupDropdown((Element)this.settingsScenarioSimulationDropdown.asWidget().asWidget().getElement());
        this.settingsScenarioSimulationDropdown.init();
    }

    @Override
    public void setScenarioType(ScenarioSimulationModel.Type scenarioType, Settings settings, String fileName) {
        this.settings = settings;
        ((SettingsView)this.view).getScenarioType().setInnerText(scenarioType.name());
        ((SettingsView)this.view).getFileName().setValue(fileName);
        ((SettingsView)this.view).getSkipFromBuild().setChecked(settings.isSkipFromBuild());
        switch (scenarioType) {
            case RULE: {
                this.setRuleSettings(settings);
                break;
            }
            case DMN: {
                this.setDMNSettings(settings);
                break;
            }
        }
    }

    @Override
    public void reset() {
        ((SettingsView)this.view).reset();
        this.settingsScenarioSimulationDropdown.clear();
    }

    public SettingsView getView() {
        return (SettingsView)this.view;
    }

    protected void setRuleSettings(Settings settings) {
        ((SettingsView)this.view).getDmnSettings().getStyle().setDisplay(Style.Display.NONE);
        ((SettingsView)this.view).getRuleSettings().getStyle().setDisplay(Style.Display.INLINE);
        ((SettingsView)this.view).getDmoSession().setValue(Optional.ofNullable(settings.getDmoSession()).orElse(""));
        ((SettingsView)this.view).getRuleFlowGroup().setValue(Optional.ofNullable(settings.getRuleFlowGroup()).orElse(""));
        ((SettingsView)this.view).getStateless().setChecked(settings.isStateless());
    }

    protected void setDMNSettings(Settings settings) {
        ((SettingsView)this.view).getRuleSettings().getStyle().setDisplay(Style.Display.NONE);
        ((SettingsView)this.view).getDmnSettings().getStyle().setDisplay(Style.Display.INLINE);
        ((SettingsView)this.view).getDmnName().setValue(Optional.ofNullable(settings.getDmnName()).orElse(""));
        ((SettingsView)this.view).getDmnNamespace().setValue(Optional.ofNullable(settings.getDmnNamespace()).orElse(""));
        ((SettingsView)this.view).getDmnFilePathErrorLabel().getStyle().setDisplay(Style.Display.NONE);
        ((SettingsView)this.view).getDmnFilePathErrorLabel().setInnerText("");
        this.settingsScenarioSimulationDropdown.registerOnMissingValueHandler(this::setDmnErrorPath);
        this.settingsScenarioSimulationDropdown.registerOnChangeHandler(this::validateDmnPath);
        this.settingsScenarioSimulationDropdown.loadAssets(settings.getDmnFilePath());
    }

    @Override
    public void syncDmoSession() {
        this.settings.setDmoSession(this.getCleanValue(() -> ((SettingsView)this.view).getDmoSession().getValue()));
    }

    @Override
    public void syncRuleFlowGroup() {
        this.settings.setRuleFlowGroup(this.getCleanValue(() -> ((SettingsView)this.view).getRuleFlowGroup().getValue()));
    }

    @Override
    public void syncStateless() {
        this.settings.setStateless(((SettingsView)this.view).getStateless().isChecked());
    }

    @Override
    public void syncDmnFilePath() {
        String value = this.settingsScenarioSimulationDropdown.getValue().map(KieAssetsDropdownItem::getValue).orElse("");
        this.settings.setDmnFilePath(this.getCleanValue(() -> value));
    }

    @Override
    public void syncSkipFromBuild() {
        this.settings.setSkipFromBuild(((SettingsView)this.view).getSkipFromBuild().isChecked());
    }

    protected void setDmnErrorPath() {
        ((SettingsView)this.view).getDmnFilePathErrorLabel().getStyle().setDisplay(Style.Display.INLINE);
        ((SettingsView)this.view).getDmnFilePathErrorLabel().setInnerText(ScenarioSimulationEditorConstants.INSTANCE.dmnPathErrorLabel(this.settings.getDmnFilePath()));
    }

    protected void validateDmnPath() {
        boolean isValid;
        Optional value = this.settingsScenarioSimulationDropdown.getValue();
        String selectedPath = value.map(KieAssetsDropdownItem::getValue).orElse(null);
        boolean bl = isValid = selectedPath != null && !selectedPath.isEmpty();
        if (!isValid) {
            ((SettingsView)this.view).getDmnFilePathErrorLabel().getStyle().setDisplay(Style.Display.INLINE);
            ((SettingsView)this.view).getDmnFilePathErrorLabel().setInnerText(ScenarioSimulationEditorConstants.INSTANCE.chooseValidDMNAsset());
        } else {
            this.syncDmnFilePath();
            ((SettingsView)this.view).getDmnFilePathErrorLabel().getStyle().setDisplay(Style.Display.NONE);
            ((SettingsView)this.view).getDmnFilePathErrorLabel().setInnerText("");
        }
    }

    private String getCleanValue(Supplier<String> supplier) {
        String rawValue = supplier.get();
        return "".equals(rawValue) ? null : rawValue;
    }
}

