/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationViolation;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationBuilders;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.kie.workbench.common.command.client.CommandResult;
import org.kie.workbench.common.command.client.CommandResultBuilder;
import org.kie.workbench.common.command.client.impl.CommandResultImpl;

public abstract class AbstractScenarioGridCommand
extends AbstractScenarioSimulationCommand {
    protected GridWidget gridWidget;
    protected ScenarioSimulationContext.Status restorableStatus = null;

    protected AbstractScenarioGridCommand(GridWidget gridWidget) {
        this.gridWidget = gridWidget;
    }

    protected AbstractScenarioGridCommand() {
    }

    @Override
    public CommandResult<ScenarioSimulationViolation> execute(ScenarioSimulationContext context) {
        this.restorableStatus = context.getStatus().cloneStatus();
        return super.execute(context);
    }

    @Override
    public CommandResult<ScenarioSimulationViolation> undo(ScenarioSimulationContext context) {
        if (this.restorableStatus == null) {
            String message = ((Object)((Object)this)).getClass().getSimpleName() + "restorableStatus status is null";
            throw new IllegalStateException(message);
        }
        return this.setCurrentContext(context);
    }

    public CommandResult<ScenarioSimulationViolation> redo(ScenarioSimulationContext context) {
        if (this.restorableStatus == null) {
            String message = ((Object)((Object)this)).getClass().getSimpleName() + "restorableStatus status is null";
            throw new IllegalStateException(message);
        }
        return this.setCurrentContext(context);
    }

    protected CommandResult<ScenarioSimulationViolation> setCurrentContext(ScenarioSimulationContext context) {
        try {
            Simulation simulationToRestore = this.restorableStatus.getSimulation();
            Background backgroundToRestore = this.restorableStatus.getBackground();
            if (simulationToRestore == null) {
                throw new IllegalStateException("Simulation is null in restorable status");
            }
            if (backgroundToRestore == null) {
                throw new IllegalStateException("Background is null in restorable status");
            }
            ScenarioSimulationContext.Status originalStatus = context.getStatus().cloneStatus();
            context.getSimulationGrid().getModel().clearSelections();
            context.getBackgroundGrid().getModel().clearSelections();
            context.getSimulationGrid().setContent((AbstractScesimModel)simulationToRestore, context.getSettings().getType());
            context.getScenarioSimulationEditorPresenter().getModel().setSimulation(simulationToRestore);
            context.getBackgroundGrid().setContent((AbstractScesimModel)backgroundToRestore, context.getSettings().getType());
            context.getScenarioSimulationEditorPresenter().getModel().setBackground(backgroundToRestore);
            context.getScenarioSimulationEditorPresenter().reloadTestTools(true);
            context.setStatus(this.restorableStatus);
            this.restorableStatus = originalStatus;
            return this.commonExecution(context);
        }
        catch (Exception e) {
            return new CommandResultImpl(CommandResult.Type.ERROR, Collections.singleton(new ScenarioSimulationViolation(e.getMessage())));
        }
    }

    public Optional<CommandResult<ScenarioSimulationViolation>> commonUndoRedoPreexecution(ScenarioSimulationContext context) {
        Optional<GridWidget> selectedGridWidgetOptional = context.getSelectedGridWidget();
        if (selectedGridWidgetOptional.isPresent() && Objects.equals((Object)this.gridWidget, (Object)selectedGridWidgetOptional.get())) {
            return Optional.empty();
        }
        switch (this.gridWidget) {
            case SIMULATION: {
                context.getScenarioSimulationEditorPresenter().selectSimulationTab();
                break;
            }
            case BACKGROUND: {
                context.getScenarioSimulationEditorPresenter().selectBackgroundTab();
                break;
            }
            default: {
                throw new IllegalStateException("Illegal GridWidget " + (Object)((Object)this.gridWidget));
            }
        }
        context.getScenarioGridPanelByGridWidget(this.gridWidget).onResize();
        context.getScenarioGridPanelByGridWidget(this.gridWidget).select();
        return Optional.of(CommandResultBuilder.SUCCESS);
    }

    protected ScenarioGridColumn getScenarioGridColumnLocal(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader, ScenarioCellTextAreaSingletonDOMElementFactory factoryCell, String placeHolder) {
        ScenarioSimulationBuilders.HeaderBuilder headerBuilder = ScenarioSimulationUtils.getHeaderBuilder(instanceTitle, propertyTitle, columnId, columnGroup, factMappingType, factoryHeader);
        return ScenarioSimulationUtils.getScenarioGridColumn(headerBuilder, factoryCell, placeHolder);
    }

    protected Optional<FactIdentifier> getFactIdentifierByColumnTitle(String columnTitle, ScenarioSimulationContext context) {
        return context.getAbstractScesimGridModelByGridWidget(this.gridWidget).getColumns().stream().filter(column -> columnTitle.equals(((ScenarioGridColumn)((Object)column)).getInformationHeaderMetaData().getTitle())).findFirst().map(column -> ((ScenarioGridColumn)((Object)column)).getFactIdentifier());
    }
}

