/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.utils;

import com.ait.lienzo.client.core.types.Point2D;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

public class ScenarioSimulationGridHeaderUtilities {
    public static ScenarioHeaderMetaData getColumnScenarioHeaderMetaData(GridWidget gridWidget, Point2D relativePoint) {
        GridColumn<?> column = ScenarioSimulationGridHeaderUtilities.getGridColumn(gridWidget, relativePoint.getX());
        if (column == null) {
            return null;
        }
        Integer uiHeaderRowIndex = CoordinateUtilities.getUiHeaderRowIndex((GridWidget)gridWidget, (Point2D)relativePoint);
        if (uiHeaderRowIndex == null) {
            return null;
        }
        return (ScenarioHeaderMetaData)((Object)column.getHeaderMetaData().get(uiHeaderRowIndex));
    }

    public static ScenarioHeaderMetaData getColumnScenarioHeaderMetaData(ScenarioGridColumn scenarioGridColumn, int uiRowIndex) {
        if (scenarioGridColumn.getHeaderMetaData().size() > uiRowIndex) {
            return (ScenarioHeaderMetaData)((Object)scenarioGridColumn.getHeaderMetaData().get(uiRowIndex));
        }
        return null;
    }

    public static GridColumn<?> getGridColumn(GridWidget gridWidget, double cx) {
        BaseGridRendererHelper rendererHelper = gridWidget.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation ri = rendererHelper.getRenderingInformation();
        if (ri == null) {
            return null;
        }
        BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(cx);
        return ci.getColumn();
    }

    public static boolean isEditableHeader(ScenarioGridColumn column, Integer uiHeaderRowIndex) {
        GridColumn.HeaderMetaData headerMetaData = (GridColumn.HeaderMetaData)column.getHeaderMetaData().get(uiHeaderRowIndex);
        if (!(headerMetaData instanceof ScenarioHeaderMetaData)) {
            throw new IllegalStateException("Header metadata has to be an instance of ScenarioHeaderMetaData");
        }
        ScenarioHeaderMetaData scenarioHeaderMetaData = (ScenarioHeaderMetaData)headerMetaData;
        if (scenarioHeaderMetaData.isEditingMode() || scenarioHeaderMetaData.isReadOnly()) {
            return false;
        }
        if (!column.isInstanceAssigned() || !column.isEditableHeaders()) {
            return false;
        }
        return scenarioHeaderMetaData.isInstanceHeader() || scenarioHeaderMetaData.isPropertyHeader() && column.isPropertyAssigned();
    }

    public static EnableTestToolsEvent getEnableTestToolsEvent(ScenarioGrid scenarioGrid, ScenarioGridColumn scenarioGridColumn, ScenarioHeaderMetaData clickedScenarioHeaderMetadata, Integer uiColumnIndex, String columnGroup) {
        if (!scenarioGridColumn.isInstanceAssigned()) {
            String complexSearch = ScenarioSimulationGridHeaderUtilities.getExistingInstances(columnGroup, scenarioGrid.getModel());
            return new EnableTestToolsEvent(complexSearch, true);
        }
        if (Objects.equals((Object)clickedScenarioHeaderMetadata.getMetadataType(), (Object)ScenarioHeaderMetaData.MetadataType.PROPERTY)) {
            String propertyName = null;
            if (scenarioGridColumn.isPropertyAssigned()) {
                Optional<Simulation> optionalSimulation = scenarioGrid.getModel().getSimulation();
                propertyName = optionalSimulation.map(simulation -> ScenarioSimulationGridHeaderUtilities.getPropertyName(simulation, uiColumnIndex)).orElse(null);
            }
            return propertyName != null ? new EnableTestToolsEvent(scenarioGridColumn.getInformationHeaderMetaData().getTitle(), propertyName) : new EnableTestToolsEvent(scenarioGridColumn.getInformationHeaderMetaData().getTitle());
        }
        String complexSearch = ScenarioSimulationGridHeaderUtilities.getExistingInstances(columnGroup, scenarioGrid.getModel());
        return new EnableTestToolsEvent(complexSearch, true);
    }

    public static String getExistingInstances(String group, ScenarioGridModel scenarioGridModel) {
        boolean isDMN = scenarioGridModel.getSimulation().get().getSimulationDescriptor().getType().equals((Object)ScenarioSimulationModel.Type.DMN);
        return String.join((CharSequence)";", scenarioGridModel.getColumns().stream().filter(gridColumn -> {
            ScenarioHeaderMetaData m = ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData();
            return isDMN || group.equals(m.getColumnGroup());
        }).map(gridColumn -> ((ScenarioGridColumn)((Object)gridColumn)).getInformationHeaderMetaData().getTitle()).collect(Collectors.toSet()));
    }

    public static String getPropertyName(Simulation simulation, int columnIndex) {
        return String.join((CharSequence)".", simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex).getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList()));
    }
}

