/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractSelectedColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;

@Dependent
public class DuplicateInstanceCommand
extends AbstractSelectedColumnCommand {
    public static final String COPY_LABEL = "_copy_";

    @Override
    protected void executeIfSelectedColumn(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn) {
        int instancesCount = context.getModel().getInstancesCount(selectedColumn.getFactIdentifier().getClassName());
        String alias = selectedColumn.getInformationHeaderMetaData().getTitle().split(COPY_LABEL)[0] + COPY_LABEL + instancesCount;
        int columnPosition = context.getModel().getInstanceLimits(context.getModel().getColumns().indexOf((Object)selectedColumn)).getMaxRowIndex() + 1;
        AtomicInteger nextColumnPosition = new AtomicInteger(columnPosition);
        context.getModel().getInstanceScenarioGridColumns(selectedColumn).forEach(originalColumn -> {
            ScenarioGridColumn createdColumn = this.insertNewColumn(context, (ScenarioGridColumn)((Object)originalColumn), nextColumnPosition.getAndIncrement(), false);
            if (originalColumn.isInstanceAssigned()) {
                this.setInstanceHeader(context, createdColumn, alias, originalColumn.getFactIdentifier().getClassName());
                if (originalColumn.isPropertyAssigned()) {
                    int originalColumnIndex = context.getModel().getColumns().indexOf(originalColumn);
                    int createdColumnIndex = context.getModel().getColumns().indexOf((Object)createdColumn);
                    FactMapping originalFactMapping = context.getModel().getSimulation().get().getSimulationDescriptor().getFactMappingByIndex(originalColumnIndex);
                    String value = alias + "." + originalFactMapping.getExpressionElements().stream().skip(1L).map(ExpressionElement::getStep).collect(Collectors.joining("."));
                    this.setPropertyHeader(context, createdColumn, value, originalFactMapping.getClassName(), Optional.of(originalColumn.getPropertyHeaderMetaData().getTitle()));
                    context.getModel().duplicateColumnValues(originalColumnIndex, createdColumnIndex);
                }
            }
        });
    }
}

