/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.popup;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.HeadingElement;
import com.google.gwt.dom.client.ParagraphElement;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.popup.AbstractScenarioConfirmationPopup;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.uberfire.client.views.pfly.widgets.Button;
import org.uberfire.client.views.pfly.widgets.Modal;
import org.uberfire.mvp.Command;

public abstract class AbstractScenarioConfirmationPopupView
implements AbstractScenarioConfirmationPopup {
    @DataField(value="main-title")
    protected HeadingElement mainTitle = Document.get().createHElement(4);
    @DataField(value="main-question")
    protected HeadingElement mainQuestion = Document.get().createHElement(2);
    @Inject
    @DataField(value="text-1")
    protected ParagraphElement text1;
    @Inject
    @DataField(value="text-question")
    protected ParagraphElement textQuestion;
    @Inject
    @DataField(value="cancel-button")
    protected Button cancelButton;
    @Inject
    @DataField(value="ok-delete-button")
    protected Button okDeleteButton;
    @Inject
    @DataField(value="modal")
    protected Modal modal;
    @Inject
    protected TranslationService translationService;
    protected Command okDeleteCommand;

    @PostConstruct
    public void init() {
        this.cancelButton.setText(this.translationService.getTranslation("ConfirmPopup.Cancel"));
    }

    @Override
    public void show(String mainTitleText, String mainQuestionText, String text1Text, String textQuestionText, String okDeleteButtonText, Command okDeleteCommand) {
        this.okDeleteCommand = okDeleteCommand;
        this.conditionalShow((Element)this.mainTitle, mainTitleText);
        this.conditionalShow((Element)this.mainQuestion, mainQuestionText);
        this.conditionalShow((Element)this.text1, text1Text);
        this.conditionalShow((Element)this.textQuestion, textQuestionText);
        this.conditionalShow(this.okDeleteButton, okDeleteCommand, okDeleteButtonText);
        this.modal.show();
    }

    @Override
    public HTMLElement getElement() {
        return this.modal.getElement();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @EventHandler(value={"ok-delete-button"})
    public void onOkDeleteClick(@ForEvent(value={"click"}) MouseEvent event) {
        if (this.okDeleteCommand != null) {
            this.okDeleteCommand.execute();
        }
        this.hide();
    }

    @EventHandler(value={"cancel-button"})
    public void onCancelClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    protected void conditionalShow(Element element, String innerText) {
        if (innerText != null) {
            element.setInnerHTML(innerText);
        } else {
            element.removeFromParent();
        }
    }

    protected void conditionalShow(Button button, Command command, String innerText) {
        if (command == null) {
            button.hide();
        } else {
            button.setText(innerText);
        }
    }
}

