/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.handlers.SourceTypeSelector;
import org.drools.workbench.screens.scenariosimulation.client.handlers.TitledAttachmentFileWidget;
import org.drools.workbench.screens.scenariosimulation.client.resources.ScenarioSimulationEditorResources;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.kie.workbench.common.screens.library.client.screens.assets.AssetQueryService;
import org.kie.workbench.common.screens.library.client.util.LibraryPlaces;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewScenarioSimulationHandler
extends DefaultNewResourceHandler {
    private Caller<ScenarioSimulationService> scenarioSimulationService;
    private ScenarioSimulationResourceType resourceType;
    private final AuthorizationManager authorizationManager;
    private final SessionInfo sessionInfo;
    private final LibraryPlaces libraryPlaces;
    private final AssetQueryService assetQueryService;
    private TitledAttachmentFileWidget uploadWidget;
    private SourceTypeSelector sourceTypeSelector;

    @Inject
    public NewScenarioSimulationHandler(ScenarioSimulationResourceType resourceType, BusyIndicatorView busyIndicatorView, Event<NotificationEvent> notificationEvent, Event<NewResourceSuccessEvent> newResourceSuccessEvent, PlaceManager placeManager, Caller<ScenarioSimulationService> scenarioSimulationService, AuthorizationManager authorizationManager, SessionInfo sessionInfo, LibraryPlaces libraryPlaces, AssetQueryService assetQueryService) {
        this.resourceType = resourceType;
        this.authorizationManager = authorizationManager;
        this.sessionInfo = sessionInfo;
        this.newResourceSuccessEvent = newResourceSuccessEvent;
        this.busyIndicatorView = busyIndicatorView;
        this.scenarioSimulationService = scenarioSimulationService;
        this.placeManager = placeManager;
        this.notificationEvent = notificationEvent;
        this.libraryPlaces = libraryPlaces;
        this.assetQueryService = assetQueryService;
    }

    public String getDescription() {
        return ScenarioSimulationEditorConstants.INSTANCE.newScenarioSimulationDescription();
    }

    public IsWidget getIcon() {
        return new Image(ScenarioSimulationEditorResources.INSTANCE.images().typeScenarioSimulation());
    }

    public ResourceTypeDefinition getResourceType() {
        return this.resourceType;
    }

    public boolean canCreate() {
        return this.authorizationManager.authorize((Resource)new ResourceRef("ScenarioSimulationEditor", (ResourceType)ActivityResourceType.EDITOR), ResourceAction.READ, this.sessionInfo.getIdentity());
    }

    public void create(Package pkg, String baseFileName, NewResourcePresenter presenter) {
        String value;
        ScenarioSimulationModel.Type selectedType = this.sourceTypeSelector.getSelectedType();
        switch (selectedType) {
            case DMN: {
                value = this.uploadWidget.getSelectedPath();
                if (value != null && !value.isEmpty()) break;
                return;
            }
            default: {
                value = "default";
            }
        }
        this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Saving());
        ((ScenarioSimulationService)this.scenarioSimulationService.call(this.getSuccessCallback(presenter), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).create(pkg.getPackageTestResourcesPath(), this.buildFileName(baseFileName, (ResourceTypeDefinition)this.resourceType), new ScenarioSimulationModel(), "", selectedType, value);
    }

    @PostConstruct
    public void setupExtensions() {
        this.uploadWidget = new TitledAttachmentFileWidget(ScenarioSimulationEditorConstants.INSTANCE.chooseDMN(), this.libraryPlaces, this.assetQueryService);
        this.sourceTypeSelector = new SourceTypeSelector(this.uploadWidget);
        this.extensions.add(Pair.newPair((Object)ScenarioSimulationEditorConstants.INSTANCE.sourceType(), (Object)((Object)this.sourceTypeSelector)));
        this.extensions.add(Pair.newPair((Object)"", (Object)((Object)this.uploadWidget)));
    }
}

