/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationViolation;
import org.drools.workbench.screens.scenariosimulation.client.factories.FactoryProvider;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationBuilders;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.kie.workbench.common.command.client.AbstractCommand;
import org.kie.workbench.common.command.client.CommandResult;
import org.kie.workbench.common.command.client.CommandResultBuilder;
import org.kie.workbench.common.command.client.impl.CommandResultImpl;

public abstract class AbstractScenarioSimulationCommand
extends AbstractCommand<ScenarioSimulationContext, ScenarioSimulationViolation> {
    private static final AtomicLong COUNTER_ID = new AtomicLong();
    private final long id = COUNTER_ID.getAndIncrement();
    private final boolean undoable;
    protected ScenarioSimulationContext.Status restorableStatus = null;

    protected AbstractScenarioSimulationCommand(boolean undoable) {
        this.undoable = undoable;
    }

    public long getId() {
        return this.id;
    }

    public boolean isUndoable() {
        return this.undoable;
    }

    public CommandResult<ScenarioSimulationViolation> undo(ScenarioSimulationContext context) throws UnsupportedOperationException {
        if (!this.undoable || this.restorableStatus == null) {
            String message = !this.undoable ? ((Object)((Object)this)).getClass().getSimpleName() + " is not undoable" : "restorableStatus status is null";
            throw new UnsupportedOperationException(message);
        }
        return this.setCurrentContext(context);
    }

    public CommandResult<ScenarioSimulationViolation> redo(ScenarioSimulationContext context) throws UnsupportedOperationException {
        if (!this.undoable || this.restorableStatus == null) {
            String message = !this.undoable ? ((Object)((Object)this)).getClass().getSimpleName() + " is not redoable" : "restorableStatus status is null";
            throw new UnsupportedOperationException(message);
        }
        return this.setCurrentContext(context);
    }

    public CommandResult<ScenarioSimulationViolation> execute(ScenarioSimulationContext context) {
        context.setStatusSimulationIfEmpty();
        if (this.undoable) {
            this.restorableStatus = context.getStatus().cloneStatus();
        }
        try {
            this.internalExecute(context);
            return this.commonExecution(context);
        }
        catch (Exception e) {
            return new CommandResultImpl(CommandResult.Type.ERROR, Collections.singleton(new ScenarioSimulationViolation(e.getMessage())));
        }
    }

    protected CommandResult<ScenarioSimulationViolation> setCurrentContext(ScenarioSimulationContext context) {
        try {
            Simulation toRestore = this.restorableStatus.getSimulation();
            if (toRestore != null) {
                ScenarioSimulationContext.Status originalStatus = context.getStatus().cloneStatus();
                context.getScenarioSimulationEditorPresenter().getView().setContent(toRestore);
                context.getScenarioSimulationEditorPresenter().getModel().setSimulation(toRestore);
                context.setStatus(this.restorableStatus);
                this.restorableStatus = originalStatus;
                return this.commonExecution(context);
            }
            return new CommandResultImpl(CommandResult.Type.ERROR, Collections.singletonList(new ScenarioSimulationViolation("Simulation not set inside Model")));
        }
        catch (Exception e) {
            return new CommandResultImpl(CommandResult.Type.ERROR, Collections.singleton(new ScenarioSimulationViolation(e.getMessage())));
        }
    }

    protected abstract void internalExecute(ScenarioSimulationContext var1);

    protected ScenarioGridColumn getScenarioGridColumnLocal(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioGridPanel scenarioGridPanel, ScenarioGridLayer gridLayer, String placeHolder) {
        ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader = FactoryProvider.getHeaderTextBoxFactory(scenarioGridPanel, gridLayer);
        ScenarioSimulationBuilders.HeaderBuilder headerBuilder = ScenarioSimulationUtils.getHeaderBuilder(instanceTitle, propertyTitle, columnId, columnGroup, factMappingType, factoryHeader);
        return ScenarioSimulationUtils.getScenarioGridColumn(headerBuilder, scenarioGridPanel, gridLayer, placeHolder);
    }

    protected ScenarioGridColumn getScenarioGridColumnLocal(ScenarioSimulationBuilders.HeaderBuilder headerBuilder, ScenarioSimulationContext context) {
        return ScenarioSimulationUtils.getScenarioGridColumn(headerBuilder, context.getScenarioGridPanel(), context.getScenarioGridLayer(), ScenarioSimulationEditorConstants.INSTANCE.insertValue());
    }

    protected Optional<FactIdentifier> getFactIdentifierByColumnTitle(String columnTitle, ScenarioSimulationContext context) {
        return context.getScenarioGridLayer().getScenarioGrid().getModel().getColumns().stream().filter(column -> columnTitle.equals(((ScenarioGridColumn)((Object)column)).getInformationHeaderMetaData().getTitle())).findFirst().map(column -> ((ScenarioGridColumn)((Object)column)).getFactIdentifier());
    }

    protected CommandResult<ScenarioSimulationViolation> commonExecution(ScenarioSimulationContext context) {
        context.getScenarioGridPanel().onResize();
        context.getScenarioGridPanel().select();
        return CommandResultBuilder.SUCCESS;
    }
}

