/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.events.SetColumnValueEvent;
import org.drools.workbench.screens.scenariosimulation.client.models.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@Dependent
@WorkbenchScreen(identifier="org.drools.scenariosimulation.RightPanel", preferredWidth=300)
public class RightPanelPresenter
implements RightPanelView.Presenter {
    public static final int DEFAULT_PREFERRED_WIDHT = 300;
    public static final String IDENTIFIER = "org.drools.scenariosimulation.RightPanel";
    private RightPanelView view;
    private ListGroupItemPresenter listGroupItemPresenter;
    Map<String, FactModelTree> factTypeFieldsMap;
    EventBus eventBus;
    int editingColumnIndex = -1;

    public RightPanelPresenter() {
    }

    @Inject
    public RightPanelPresenter(RightPanelView view, ListGroupItemPresenter listGroupItemPresenter) {
        this.view = view;
        this.listGroupItemPresenter = listGroupItemPresenter;
        this.listGroupItemPresenter.init(this);
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    @DefaultPosition
    public Position getDefaultPosition() {
        return CompassPosition.EAST;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return ScenarioSimulationEditorConstants.INSTANCE.testTools();
    }

    @WorkbenchPartView
    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void onClearSearch() {
        this.view.clearInputSearch();
        this.view.hideClearButton();
        this.onSearchedEvent("");
    }

    @Override
    public void onClearNameField() {
        this.view.clearNameField();
    }

    @Override
    public void onClearStatus() {
        this.onClearSearch();
        this.onClearNameField();
    }

    @Override
    public void clearList() {
        this.view.getListContainer().removeAllChildren();
    }

    @Override
    public FactModelTree getFactModelTree(String factName) {
        return this.factTypeFieldsMap.get(factName);
    }

    @Override
    public void setFactTypeFieldsMap(SortedMap<String, FactModelTree> factTypeFieldsMap) {
        this.clearList();
        this.factTypeFieldsMap = factTypeFieldsMap;
        this.factTypeFieldsMap.forEach(this::addListGroupItemView);
    }

    @Override
    public void onShowClearButton() {
        this.view.showClearButton();
    }

    @Override
    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public void onSearchedEvent(String search) {
        this.clearList();
        if (this.factTypeFieldsMap.isEmpty()) {
            return;
        }
        this.factTypeFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(search.toLowerCase())).forEach(filteredEntry -> this.addListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
    }

    @Override
    public void addListGroupItemView(String factName, FactModelTree factModelTree) {
        DivElement toAdd = this.listGroupItemPresenter.getDivElement(factName, factModelTree);
        this.view.getListContainer().appendChild((Node)toAdd);
    }

    @Override
    public void onEnableEditorTab(int columnIndex) {
        this.listGroupItemPresenter.setDisabled(false);
        this.editingColumnIndex = columnIndex;
        this.view.enableEditorTab();
    }

    @Override
    public void onDisableEditorTab() {
        this.listGroupItemPresenter.setDisabled(true);
        this.editingColumnIndex = -1;
        this.view.disableEditorTab();
    }

    @Override
    public void onModifyColumn(String factName, String fieldName, String valueClassName) {
        if (this.editingColumnIndex > -1) {
            String value = factName + "." + fieldName;
            String baseClass = factName.split("\\.")[0];
            String fullPackage = this.getFactModelTree(baseClass).getFullPackage();
            this.eventBus.fireEvent((GwtEvent)new SetColumnValueEvent(this.editingColumnIndex, fullPackage, value, valueClassName));
        }
    }
}

