/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.menu;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.BaseMenuView;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.MenuItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.events.RefreshMenusEvent;

public abstract class BaseMenu
implements IsWidget,
BaseMenuView.BaseMenuPresenter {
    @Inject
    protected MenuItemPresenter menuItemPresenter;
    @Inject
    protected BaseMenuView view;

    @Override
    @PostConstruct
    public void initialise() {
        this.view.init(this);
    }

    @Override
    public void addMenuItem(String id, String label, String i18n, Command command) {
        this.view.getContextMenuDropdown().appendChild((Node)this.menuItemPresenter.getLIElement(id, label, command));
    }

    @Override
    public void onRefreshMenusEvent(RefreshMenusEvent event) {
        this.initialise();
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void show(int mx, int my) {
        this.hide();
        this.getRootPanel().add((IsWidget)this);
        this.view.getContextMenuDropdown().getStyle().setLeft((double)mx, Style.Unit.PX);
        this.view.getContextMenuDropdown().getStyle().setTop((double)my, Style.Unit.PX);
        this.view.getContextMenuDropdown().getStyle().setDisplay(Style.Display.BLOCK);
    }

    @Override
    public void hide() {
        if (this.isShown()) {
            this.getRootPanel().remove((IsWidget)this);
            this.view.getContextMenuDropdown().getStyle().setDisplay(Style.Display.NONE);
        }
    }

    @Override
    public boolean isShown() {
        return this.getRootPanel().getWidgetIndex((IsWidget)this.view) != -1;
    }

    @Override
    public BaseMenuView getView() {
        return this.view;
    }

    @Override
    public void enableElement(Element element, boolean enabled) {
        if (enabled) {
            element.removeClassName("disabled");
        } else {
            element.addClassName("disabled");
        }
    }

    @Override
    public boolean isDisabled(Element element) {
        List<String> classNames = Arrays.asList(element.getClassName().split("\\s"));
        return classNames.contains("disabled");
    }

    @Override
    public void onContextMenuEvent(ContextMenuEvent event) {
        event.preventDefault();
        event.stopPropagation();
        this.hide();
    }

    protected RootPanel getRootPanel() {
        return RootPanel.get();
    }
}

