/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.Locale;
import org.drools.workbench.jcr2vfsmigration.JcrExporter;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;

public class JcrExporterLauncher {
    private Weld weld;
    private WeldContainer weldContainer;
    private JcrExporter exporter;

    public static void main(String[] args) {
        try {
            new JcrExporterLauncher().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void run(String ... args) {
        this.startUp();
        try {
            this.launchExport(args);
        }
        finally {
            this.shutdown();
        }
    }

    private void launchExport(String ... args) {
        if (this.exporter.parseArgs(args)) {
            this.exporter.exportAll();
        }
    }

    private void shutdown() {
        this.weld.shutdown();
    }

    private void startUp() {
        this.disableAnnoyingJackrabbitSysouts();
        String dateFormatProperty = System.getProperty("drools.dateformat");
        if (dateFormatProperty == null || dateFormatProperty.length() == 0) {
            System.setProperty("drools.dateformat", "dd-MM-yyyy");
        }
        this.weld = new Weld();
        this.weldContainer = this.weld.initialize();
        this.exporter = (JcrExporter)this.weldContainer.instance().select(JcrExporter.class, new Annotation[0]).get();
    }

    private void disableAnnoyingJackrabbitSysouts() {
        PrintStream origSysout = System.out;
        System.setOut(new JackrabbitFilteredPrintStream(origSysout));
    }

    private static class JackrabbitFilteredPrintStream
    extends PrintStream {
        private final PrintStream delegate;

        private JackrabbitFilteredPrintStream(PrintStream delegate) {
            super(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    throw new IllegalStateException("NO-OP OutputStream.write() method called!");
                }
            });
            this.delegate = delegate;
        }

        @Override
        public void flush() {
            this.delegate.flush();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public void write(int b) {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            this.delegate.write(buf, off, len);
        }

        @Override
        public void print(boolean b) {
            this.delegate.print(b);
        }

        @Override
        public void print(char c) {
            this.delegate.print(c);
        }

        @Override
        public void print(int i) {
            this.delegate.print(i);
        }

        @Override
        public void print(long l) {
            this.delegate.print(l);
        }

        @Override
        public void print(float f) {
            this.delegate.print(f);
        }

        @Override
        public void print(double d) {
            this.delegate.print(d);
        }

        @Override
        public void print(char[] s) {
            this.delegate.print(s);
        }

        @Override
        public void print(String s) {
            this.delegate.print(s);
        }

        @Override
        public void print(Object obj) {
            this.delegate.print(obj);
        }

        @Override
        public void println() {
            this.delegate.println();
        }

        @Override
        public void println(boolean b) {
            this.delegate.println(b);
        }

        @Override
        public void println(char c) {
            this.delegate.println(c);
        }

        @Override
        public void println(int i) {
            this.delegate.println(i);
        }

        @Override
        public void println(long l) {
            this.delegate.println(l);
        }

        @Override
        public void println(float f) {
            this.delegate.println(f);
        }

        @Override
        public void println(double d) {
            this.delegate.println(d);
        }

        @Override
        public void println(char[] s) {
            this.delegate.println(s);
        }

        @Override
        public void println(Object obj) {
            this.delegate.println(obj);
        }

        @Override
        public PrintStream printf(String format, Object ... args) {
            return this.delegate.printf(format, args);
        }

        @Override
        public PrintStream printf(Locale l, String format, Object ... args) {
            return this.delegate.printf(l, format, args);
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            return this.delegate.format(format, args);
        }

        @Override
        public PrintStream format(Locale l, String format, Object ... args) {
            return this.delegate.format(l, format, args);
        }

        @Override
        public PrintStream append(CharSequence csq) {
            return this.delegate.append(csq);
        }

        @Override
        public PrintStream append(CharSequence csq, int start, int end) {
            return this.delegate.append(csq, start, end);
        }

        @Override
        public PrintStream append(char c) {
            return this.delegate.append(c);
        }

        @Override
        public void println(String msg) {
            if (msg.startsWith("=============== session-guest")) {
                return;
            }
            this.delegate.println(msg);
        }
    }
}

