/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.jcrExport;

import java.io.PrintWriter;
import java.util.ArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.guvnor.server.RepositoryCategoryService;
import org.drools.workbench.jcr2vfsmigration.common.FileManager;
import org.drools.workbench.jcr2vfsmigration.xml.format.CategoriesXmlFormat;
import org.drools.workbench.jcr2vfsmigration.xml.model.Categories;
import org.drools.workbench.jcr2vfsmigration.xml.model.Category;

@ApplicationScoped
public class CategoryExporter {
    @Inject
    protected RepositoryCategoryService jcrRepositoryCategoryService;
    @Inject
    FileManager fileManager;
    CategoriesXmlFormat categoriesXmlFormat = new CategoriesXmlFormat();

    public void exportAll() {
        System.out.println("  Category export started");
        StringBuilder xml = new StringBuilder();
        this.categoriesXmlFormat.format(xml, this.export("/"));
        PrintWriter pw = this.fileManager.createCategoryExportFileWriter();
        pw.print(xml.toString());
        pw.close();
        System.out.println("  Category export ended");
    }

    private Categories export(String category) {
        String[] categories = this.jcrRepositoryCategoryService.loadChildCategories(category);
        ArrayList<Category> cCategories = new ArrayList<Category>(categories.length);
        for (String c : categories) {
            Category _category = new Category(c, this.export(this.getCategoryPath(c, category)));
            cCategories.add(_category);
        }
        return new Categories(cCategories);
    }

    private String getCategoryPath(String categoryName, String parentPath) {
        if ("/".equals(parentPath)) {
            return parentPath + categoryName;
        }
        return parentPath + "/" + categoryName;
    }
}

