/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.jcrExport.asset;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.drools.guvnor.client.asseteditor.drools.factmodel.AnnotationMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactMetaModel;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FactModels;
import org.drools.guvnor.client.asseteditor.drools.factmodel.FieldMetaModel;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.AssetExporter;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.BaseAssetExporter;
import org.drools.workbench.jcr2vfsmigration.jcrExport.asset.ExportContext;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.DataModelAsset;

public class FactModelExporter
extends BaseAssetExporter
implements AssetExporter<DataModelAsset, ExportContext> {
    @Inject
    private RepositoryAssetService jcrRepositoryAssetService;

    @Override
    public DataModelAsset export(ExportContext exportContext) {
        DataModelAsset dma = new DataModelAsset(exportContext.getJcrAssetItem().getName(), exportContext.getJcrAssetItem().getFormat(), exportContext.getJcrAssetItem().getLastContributor(), exportContext.getJcrAssetItem().getCheckinComment(), exportContext.getJcrAssetItem().getLastModified().getTime());
        String normalizedPackageName = exportContext.getJcrModule().getName();
        Asset jcrAsset = null;
        try {
            jcrAsset = this.jcrRepositoryAssetService.loadRuleAsset(exportContext.getJcrAssetItem().getUUID());
        }
        catch (SerializationException e) {
            System.out.println("Error: " + e.getMessage());
            return null;
        }
        FactModels factModels = (FactModels)jcrAsset.getContent();
        for (FactMetaModel factMetaModel : factModels.models) {
            DataModelAsset.DataModelObject dataModelObject = dma.addDataModelObject(factMetaModel.getName(), factMetaModel.getSuperType());
            List objectFields = factMetaModel.getFields();
            for (FieldMetaModel fieldMetaModel : objectFields) {
                String fieldName = fieldMetaModel.name;
                String fieldType = fieldMetaModel.type;
                dataModelObject.addObjectProperty(fieldName, fieldType);
            }
            List objectAnnotations = factMetaModel.getAnnotations();
            for (AnnotationMetaModel annotationMetaModel : objectAnnotations) {
                String annotationName = annotationMetaModel.name;
                Map values = annotationMetaModel.values;
                String key = "value";
                String value = "";
                if (values.size() > 0) {
                    key = (String)values.keySet().iterator().next();
                    value = (String)values.values().iterator().next();
                }
                dataModelObject.addObjectAnnotation(annotationName, key, value);
            }
        }
        return dma;
    }
}

