/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.template.server;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.commons.shared.rule.RuleModel;
import org.drools.workbench.models.guided.template.backend.BRDRTXMLPersistence;
import org.drools.workbench.models.guided.template.shared.TemplateModel;
import org.drools.workbench.screens.guided.template.model.GuidedTemplateEditorContent;
import org.drools.workbench.screens.guided.template.service.GuidedRuleTemplateEditorService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.base.options.CommentedOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.workbench.common.services.backend.SourceServices;
import org.kie.workbench.common.services.datamodel.events.InvalidateDMOPackageCacheEvent;
import org.kie.workbench.common.services.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.service.DataModelService;
import org.kie.workbench.common.services.project.service.ProjectService;
import org.kie.workbench.common.services.shared.file.CopyService;
import org.kie.workbench.common.services.shared.file.DeleteService;
import org.kie.workbench.common.services.shared.file.RenameService;
import org.kie.workbench.common.services.shared.metadata.MetadataService;
import org.kie.workbench.common.services.shared.metadata.model.Metadata;
import org.kie.workbench.common.services.shared.validation.model.BuilderResult;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.security.Identity;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceOpenedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Service
@ApplicationScoped
public class GuidedRuleTemplateEditorServiceImpl
implements GuidedRuleTemplateEditorService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<InvalidateDMOPackageCacheEvent> invalidateDMOPackageCache;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private Event<ResourceAddedEvent> resourceAddedEvent;
    @Inject
    private Event<ResourceUpdatedEvent> resourceUpdatedEvent;
    @Inject
    private Paths paths;
    @Inject
    private Identity identity;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private SourceServices sourceServices;
    @Inject
    private ProjectService projectService;

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, TemplateModel content, String comment) {
        content.setPackageName(this.projectService.resolvePackageName(context));
        Path nioPath = this.paths.convert(context).resolve(fileName);
        org.uberfire.backend.vfs.Path newPath = this.paths.convert(nioPath, false);
        this.ioService.createFile(nioPath, new FileAttribute[0]);
        this.ioService.write(nioPath, BRDRTXMLPersistence.getInstance().marshal((RuleModel)content), new OpenOption[]{this.makeCommentedOption(comment)});
        this.resourceAddedEvent.fire((Object)new ResourceAddedEvent(newPath));
        return newPath;
    }

    public TemplateModel load(org.uberfire.backend.vfs.Path path) {
        String content = this.ioService.readAllString(this.paths.convert(path));
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path));
        return (TemplateModel)BRDRTXMLPersistence.getInstance().unmarshal(content);
    }

    public GuidedTemplateEditorContent loadContent(org.uberfire.backend.vfs.Path path) {
        TemplateModel model = this.load(path);
        PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
        return new GuidedTemplateEditorContent(oracle, model);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, TemplateModel model, Metadata metadata, String comment) {
        model.setPackageName(this.projectService.resolvePackageName(resource));
        this.ioService.write(this.paths.convert(resource), BRDRTXMLPersistence.getInstance().marshal((RuleModel)model), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
        this.resourceUpdatedEvent.fire((Object)new ResourceUpdatedEvent(resource));
        return resource;
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        this.deleteService.delete(path, comment);
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        return this.renameService.rename(path, newName, comment);
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        return this.copyService.copy(path, newName, comment);
    }

    public String toSource(org.uberfire.backend.vfs.Path path, TemplateModel model) {
        return this.sourceServices.getServiceFor(this.paths.convert(path)).getSource(this.paths.convert(path), (Object)model);
    }

    public BuilderResult validate(org.uberfire.backend.vfs.Path path, TemplateModel content) {
        return new BuilderResult();
    }

    public boolean isValid(org.uberfire.backend.vfs.Path path, TemplateModel content) {
        return !this.validate(path, content).hasLines();
    }

    private CommentedOption makeCommentedOption(String commitMessage) {
        String name = this.identity.getName();
        Date when = new Date();
        CommentedOption co = new CommentedOption(name, null, commitMessage, when);
        return co;
    }
}

