/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.client.editor.factPattern;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.drools.workbench.models.datamodel.rule.BaseSingleFieldConstraint;
import org.drools.workbench.models.datamodel.rule.ConnectiveConstraint;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.HasParameterizedOperator;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.screens.guided.rule.client.editor.CEPOperatorsDropdown;
import org.drools.workbench.screens.guided.rule.client.editor.ConstraintValueEditor;
import org.drools.workbench.screens.guided.rule.client.editor.OperatorSelection;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.HumanReadable;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;

public class Connectives {
    private final RuleModeller modeller;
    private final EventBus eventBus;
    private final FactPattern pattern;
    private final Boolean isReadOnly;

    public Connectives(RuleModeller modeller, EventBus eventBus, FactPattern pattern, Boolean isReadOnly) {
        this.pattern = pattern;
        this.modeller = modeller;
        this.eventBus = eventBus;
        this.isReadOnly = isReadOnly;
    }

    public FactPattern getPattern() {
        return this.pattern;
    }

    public AsyncPackageDataModelOracle getDataModelOracle() {
        return this.modeller.getDataModelOracle();
    }

    public Widget connectives(final SingleFieldConstraint c) {
        final HorizontalPanel hp = new HorizontalPanel();
        if (c.getConnectives() != null && c.getConnectives().length > 0) {
            hp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
            hp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
            for (int i = 0; i < c.getConnectives().length; ++i) {
                final int index = i;
                final ConnectiveConstraint con = c.getConnectives()[i];
                this.connectiveOperatorDropDown(con, new Callback<Widget>(){

                    public void callback(Widget w) {
                        hp.add(w);
                        hp.add(Connectives.this.connectiveValueEditor((BaseSingleFieldConstraint)con));
                        if (!Connectives.this.isReadOnly.booleanValue()) {
                            Image clear = GuidedRuleEditorImages508.INSTANCE.DeleteItemSmall();
                            clear.setAltText(GuidedRuleEditorResources.CONSTANTS.RemoveThisRestriction());
                            clear.setTitle(GuidedRuleEditorResources.CONSTANTS.RemoveThisRestriction());
                            clear.addClickHandler(Connectives.this.createClickHandlerForClearImageButton(c, index));
                            hp.add((Widget)clear);
                        }
                    }
                });
            }
        }
        return hp;
    }

    private Widget connectiveValueEditor(BaseSingleFieldConstraint con) {
        return new ConstraintValueEditor(con, this.pattern.getConstraintList(), this.modeller, this.eventBus, this.isReadOnly);
    }

    private void connectiveOperatorDropDown(final ConnectiveConstraint cc, final Callback<Widget> callback) {
        if (!this.isReadOnly.booleanValue()) {
            String factType = cc.getFactType();
            String fieldName = cc.getFieldName();
            this.getDataModelOracle().getConnectiveOperatorCompletions(factType, fieldName, (Callback)new Callback<String[]>(){

                public void callback(String[] operators) {
                    CEPOperatorsDropdown dropdown = Connectives.this.getDropdown(operators, cc);
                    dropdown.addPlaceholder(GuidedRuleEditorResources.CONSTANTS.pleaseChoose(), "");
                    dropdown.addValueChangeHandler(new ValueChangeHandler<OperatorSelection>(){

                        public void onValueChange(ValueChangeEvent<OperatorSelection> event) {
                            OperatorSelection selection = (OperatorSelection)event.getValue();
                            String selected = selection.getValue();
                            cc.setOperator(selected);
                        }
                    });
                    callback.callback((Object)dropdown);
                }
            });
        } else {
            SmallLabel w = new SmallLabel("<b>" + (cc.getOperator() == null ? GuidedRuleEditorResources.CONSTANTS.pleaseChoose() : HumanReadable.getOperatorDisplayName((String)cc.getOperator())) + "</b>");
            callback.callback((Object)w);
        }
    }

    CEPOperatorsDropdown getDropdown(String[] operators, ConnectiveConstraint connectiveConstraint) {
        return new CEPOperatorsDropdown(operators, (HasParameterizedOperator)connectiveConstraint);
    }

    private ClickHandler createClickHandlerForClearImageButton(final SingleFieldConstraint sfc, final int index) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)GuidedRuleEditorResources.CONSTANTS.RemoveThisItem())) {
                    sfc.removeConnective(index);
                    Connectives.this.modeller.refreshWidget();
                }
            }
        };
    }
}

