/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.shared;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drools.workbench.models.datamodel.rule.ActionFieldList;
import org.drools.workbench.models.datamodel.rule.ActionFieldValue;
import org.drools.workbench.models.datamodel.rule.ActionInsertFact;
import org.drools.workbench.models.datamodel.rule.ActionSetField;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.visitors.RuleModelVisitor;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableLinkManager;

public class DefaultGuidedDecisionTableLinkManager
implements GuidedDecisionTableLinkManager {
    private final RHSTypeFieldsExtractor rhsTypeFieldsExtractor = new RHSTypeFieldsExtractor();

    @Override
    public void link(GuidedDecisionTable52 model, GuidedDecisionTable52 otherModel, GuidedDecisionTableLinkManager.LinkFoundCallback callback) {
        if (model == null) {
            return;
        }
        if (otherModel == null) {
            return;
        }
        if (callback == null) {
            return;
        }
        BRLRuleModel helper = new BRLRuleModel(model);
        for (CompositeColumn otherDecisionTableConditions : otherModel.getConditions()) {
            int targetColumnIndex;
            int sourceColumnIndex;
            ActionCol52 linkedActionColumn;
            String fieldName;
            String factType;
            if (otherDecisionTableConditions instanceof Pattern52) {
                Pattern52 otherDecisionTablePattern = (Pattern52)otherDecisionTableConditions;
                for (ConditionCol52 otherDecisionTableCondition : otherDecisionTablePattern.getChildColumns()) {
                    factType = otherDecisionTablePattern.getFactType();
                    linkedActionColumn = this.getLinkedActionColumn(factType, fieldName = otherDecisionTableCondition.getFactField(), model, helper);
                    if (linkedActionColumn == null) continue;
                    sourceColumnIndex = model.getExpandedColumns().indexOf(linkedActionColumn);
                    targetColumnIndex = otherModel.getExpandedColumns().indexOf(otherDecisionTableCondition);
                    callback.link(sourceColumnIndex, targetColumnIndex);
                }
                continue;
            }
            if (!(otherDecisionTableConditions instanceof BRLConditionColumn)) continue;
            BRLConditionColumn fragment = (BRLConditionColumn)otherDecisionTableConditions;
            for (BRLConditionVariableColumn var : fragment.getChildColumns()) {
                factType = var.getFactType();
                linkedActionColumn = this.getLinkedActionColumn(factType, fieldName = var.getFactField(), model, helper);
                if (linkedActionColumn == null) continue;
                sourceColumnIndex = model.getExpandedColumns().indexOf(linkedActionColumn);
                targetColumnIndex = otherModel.getExpandedColumns().indexOf(var);
                callback.link(sourceColumnIndex, targetColumnIndex);
            }
        }
    }

    private ActionCol52 getLinkedActionColumn(String factType, String fieldName, GuidedDecisionTable52 model, BRLRuleModel helper) {
        if (factType == null || fieldName == null) {
            return null;
        }
        for (ActionCol52 ac : model.getActionCols()) {
            if (ac instanceof ActionInsertFactCol52) {
                ActionInsertFactCol52 aif = (ActionInsertFactCol52)ac;
                if (!factType.equals(aif.getFactType()) || !fieldName.equals(aif.getFactField())) continue;
                return ac;
            }
            if (ac instanceof ActionSetFieldCol52) {
                ActionSetFieldCol52 asf = (ActionSetFieldCol52)ac;
                String binding = asf.getBoundName();
                String asfFactType = helper.getLHSBindingType(binding);
                if (!factType.equals(asfFactType) || !fieldName.equals(asf.getFactField())) continue;
                return ac;
            }
            if (!(ac instanceof BRLActionColumn)) continue;
            BRLActionColumn fragment = (BRLActionColumn)ac;
            if (this.hasTemplateKeys(fragment)) {
                return this.getLinkedTemplateKeyColumn(fragment, factType, fieldName);
            }
            return this.getLinkedDefinitionColumn(model, fragment, factType, fieldName);
        }
        return null;
    }

    private boolean hasTemplateKeys(BRLActionColumn column) {
        HashMap ivs = new HashMap();
        RuleModel rm = new RuleModel();
        column.getDefinition().forEach(arg_0 -> ((RuleModel)rm).addRhsItem(arg_0));
        RuleModelVisitor rmv = new RuleModelVisitor(ivs);
        rmv.visit((Object)rm);
        return ivs.size() > 0;
    }

    private ActionCol52 getLinkedTemplateKeyColumn(BRLActionColumn fragment, String factType, String fieldName) {
        for (BRLActionVariableColumn var : fragment.getChildColumns()) {
            if (!factType.equals(var.getFactType()) || !fieldName.equals(var.getFactField())) continue;
            return var;
        }
        return null;
    }

    private ActionCol52 getLinkedDefinitionColumn(GuidedDecisionTable52 model, BRLActionColumn fragment, String factType, String fieldName) {
        Map<String, List<String>> rhsTypeFields = this.rhsTypeFieldsExtractor.extract(model, fragment.getDefinition());
        if (rhsTypeFields.containsKey(factType)) {
            for (String field : rhsTypeFields.get(factType)) {
                if (!field.equals(fieldName)) continue;
                return (ActionCol52)fragment.getChildColumns().get(0);
            }
        }
        return null;
    }

    static class RHSTypeFieldsExtractor {
        private Map<String, List<String>> typeFields = new HashMap<String, List<String>>();

        RHSTypeFieldsExtractor() {
        }

        public Map<String, List<String>> extract(GuidedDecisionTable52 dtable, List<IAction> fragment) {
            BRLRuleModel rm = new BRLRuleModel(dtable);
            fragment.stream().filter(iAction -> iAction instanceof ActionFieldList).map(iAction -> (ActionFieldList)iAction).forEach(iAction -> this.extract((RuleModel)rm, (ActionFieldList)iAction));
            return this.typeFields;
        }

        private void extract(RuleModel ruleModel, ActionFieldList actionFieldList) {
            Optional<String> type = this.getType(ruleModel, actionFieldList);
            type.ifPresent(t -> {
                ActionFieldValue[] actionFieldValues;
                for (ActionFieldValue actionFieldValue : actionFieldValues = actionFieldList.getFieldValues()) {
                    List fields = this.typeFields.computeIfAbsent((String)t, s -> new ArrayList());
                    fields.add(actionFieldValue.getField());
                }
            });
        }

        private Optional<String> getType(RuleModel ruleModel, ActionFieldList actionFieldList) {
            if (actionFieldList instanceof ActionInsertFact) {
                return Optional.of(((ActionInsertFact)actionFieldList).getFactType());
            }
            if (actionFieldList instanceof ActionSetField) {
                String var = ((ActionSetField)actionFieldList).getVariable();
                return Optional.ofNullable(ruleModel.getLHSBindingType(var));
            }
            return Optional.empty();
        }
    }
}

