/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.client.editor;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.globals.client.editor.AddGlobalPopup;
import org.drools.workbench.screens.globals.client.editor.GlobalsEditorView;
import org.drools.workbench.screens.globals.model.Global;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.metadata.client.KieEditorViewImpl;
import org.uberfire.mvp.Command;

@Templated
@Dependent
public class GlobalsEditorViewImpl
extends KieEditorViewImpl
implements GlobalsEditorView {
    @DataField(value="generatedLabel")
    Label generatedLabel;
    @DataField(value="addGlobalButton")
    Button addGlobalButton;
    @DataField(value="globalsTable")
    CellTable<Global> table = new CellTable();
    private AddGlobalPopup addGlobalPopup;
    private TranslationService translationService;
    private ButtonCell deleteGlobalButton;
    private List<Global> globals = new ArrayList<Global>();
    private ListDataProvider<Global> dataProvider = new ListDataProvider();
    private final Command addGlobalCommand = this.makeAddGlobalCommand();
    private List<String> fullyQualifiedClassNames;

    public GlobalsEditorViewImpl() {
    }

    @Inject
    public GlobalsEditorViewImpl(Label generatedLabel, Button addGlobalButton, AddGlobalPopup addGlobalPopup, TranslationService translationService) {
        this.generatedLabel = generatedLabel;
        this.addGlobalButton = addGlobalButton;
        this.addGlobalPopup = addGlobalPopup;
        this.translationService = translationService;
        this.setup();
        generatedLabel.setVisible(false);
        addGlobalButton.setEnabled(false);
    }

    private void setup() {
        this.table.setStriped(true);
        this.table.setCondensed(true);
        this.table.setBordered(true);
        this.table.setEmptyTableWidget((Widget)new Label(this.translationService.getTranslation("GlobalsEditorViewImpl.NoGlobalsDefined")));
        TextColumn<Global> aliasColumn = new TextColumn<Global>(){

            public String getValue(Global global) {
                return global.getAlias();
            }
        };
        TextColumn<Global> classNameColumn = new TextColumn<Global>(){

            public String getValue(Global global) {
                return global.getClassName();
            }
        };
        this.deleteGlobalButton = new ButtonCell(IconType.MINUS, ButtonType.DANGER, ButtonSize.SMALL);
        Column<Global, String> deleteGlobalColumn = new Column<Global, String>((Cell)this.deleteGlobalButton){

            public String getValue(Global global) {
                return GlobalsEditorViewImpl.this.translationService.getTranslation("GlobalsEditorViewImpl.Remove");
            }
        };
        deleteGlobalColumn.setFieldUpdater((index, global, value) -> {
            if (Window.confirm((String)this.translationService.format("GlobalsEditorViewImpl.PromptForRemovalOfGlobal", new Object[]{global.getAlias()}))) {
                this.dataProvider.getList().remove(index);
            }
        });
        this.table.addColumn((Column)aliasColumn, (Header)new TextHeader(this.translationService.getTranslation("GlobalsEditorViewImpl.Alias")));
        this.table.addColumn((Column)classNameColumn, (Header)new TextHeader(this.translationService.getTranslation("GlobalsEditorViewImpl.ClassName")));
        this.table.addColumn((Column)deleteGlobalColumn, this.translationService.getTranslation("GlobalsEditorViewImpl.Remove"));
        this.dataProvider.addDataDisplay(this.table);
        this.dataProvider.setList(this.globals);
        this.generatedLabel.setText(this.translationService.getTranslation("GlobalsEditorViewImpl.AutoGeneratedFile"));
        this.addGlobalButton.setText(this.translationService.getTranslation("GlobalsEditorViewImpl.Add"));
        this.addGlobalButton.setIcon(IconType.PLUS);
    }

    @Override
    public void setContent(List<Global> globals, List<String> fullyQualifiedClassNames, boolean isReadOnly, boolean isGenerated) {
        this.globals = globals;
        this.fullyQualifiedClassNames = fullyQualifiedClassNames;
        this.dataProvider.setList(globals);
        this.generatedLabel.setVisible(isGenerated);
        this.addGlobalButton.setEnabled(!isReadOnly && !isGenerated);
        this.deleteGlobalButton.setEnabled(!isReadOnly && !isGenerated);
    }

    @EventHandler(value={"addGlobalButton"})
    public void onClickAddGlobalButton(ClickEvent event) {
        this.addGlobalPopup.show(this.addGlobalCommand, () -> {}, this.fullyQualifiedClassNames);
    }

    private Command makeAddGlobalCommand() {
        return () -> {
            String alias = this.addGlobalPopup.getAlias();
            String className = this.addGlobalPopup.getClassName();
            this.dataProvider.getList().add(new Global(alias, className));
        };
    }
}

