/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.globals.client.editor;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ButtonCell;
import com.github.gwtbootstrap.client.ui.CellTable;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.drools.workbench.screens.globals.client.editor.AddGlobalPopup;
import org.drools.workbench.screens.globals.client.editor.GlobalsEditorView;
import org.drools.workbench.screens.globals.client.resources.i18n.GlobalsEditorConstants;
import org.drools.workbench.screens.globals.model.Global;
import org.kie.workbench.common.widgets.metadata.client.KieEditorViewImpl;

public class GlobalsEditorViewImpl
extends KieEditorViewImpl
implements GlobalsEditorView {
    private static GlobalsEditorViewBinder uiBinder = (GlobalsEditorViewBinder)GWT.create(GlobalsEditorViewBinder.class);
    @UiField
    Button addGlobalButton;
    @UiField(provided=true)
    CellTable<Global> table = new CellTable();
    @Inject
    private AddGlobalPopup addGlobalPopup;
    private List<Global> globals = new ArrayList<Global>();
    private ListDataProvider<Global> dataProvider = new ListDataProvider();
    private final Command addGlobalCommand = this.makeAddGlobalCommand();
    private List<String> fullyQualifiedClassNames;
    private boolean isReadOnly = false;

    public GlobalsEditorViewImpl() {
        this.setup();
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.addGlobalButton.setEnabled(false);
    }

    private void setup() {
        this.table.setStriped(true);
        this.table.setCondensed(true);
        this.table.setBordered(true);
        this.table.setEmptyTableWidget((Widget)new Label(GlobalsEditorConstants.INSTANCE.noGlobalsDefined()));
        TextColumn<Global> aliasColumn = new TextColumn<Global>(){

            public String getValue(Global global) {
                return global.getAlias();
            }
        };
        TextColumn<Global> classNameColumn = new TextColumn<Global>(){

            public String getValue(Global global) {
                return global.getClassName();
            }
        };
        ButtonCell deleteGlobalButton = new ButtonCell(ButtonSize.SMALL);
        deleteGlobalButton.setType(ButtonType.DANGER);
        deleteGlobalButton.setIcon(IconType.MINUS_SIGN);
        Column<Global, String> deleteGlobalColumn = new Column<Global, String>((Cell)deleteGlobalButton){

            public String getValue(Global global) {
                return GlobalsEditorConstants.INSTANCE.remove();
            }
        };
        deleteGlobalColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<Global, String>(){

            public void update(int index, Global global, String value) {
                if (GlobalsEditorViewImpl.this.isReadOnly) {
                    return;
                }
                if (Window.confirm((String)GlobalsEditorConstants.INSTANCE.promptForRemovalOfGlobal0(global.getAlias()))) {
                    GlobalsEditorViewImpl.this.dataProvider.getList().remove(index);
                }
            }
        });
        this.table.addColumn((Column)aliasColumn, (Header)new TextHeader(GlobalsEditorConstants.INSTANCE.alias()));
        this.table.addColumn((Column)classNameColumn, (Header)new TextHeader(GlobalsEditorConstants.INSTANCE.className()));
        this.table.addColumn((Column)deleteGlobalColumn, GlobalsEditorConstants.INSTANCE.remove());
        this.dataProvider.addDataDisplay(this.table);
        this.dataProvider.setList(this.globals);
    }

    @Override
    public void setContent(List<Global> globals, List<String> fullyQualifiedClassNames, boolean isReadOnly) {
        this.globals = globals;
        this.fullyQualifiedClassNames = fullyQualifiedClassNames;
        this.dataProvider.setList(globals);
        this.addGlobalButton.setEnabled(!isReadOnly);
        this.isReadOnly = isReadOnly;
    }

    @UiHandler(value={"addGlobalButton"})
    public void onClickAddGlobalButton(ClickEvent event) {
        this.addGlobalPopup.setContent(this.addGlobalCommand, this.fullyQualifiedClassNames);
        this.addGlobalPopup.show();
    }

    private Command makeAddGlobalCommand() {
        return new Command(){

            public void execute() {
                String alias = GlobalsEditorViewImpl.this.addGlobalPopup.getAlias();
                String className = GlobalsEditorViewImpl.this.addGlobalPopup.getClassName();
                GlobalsEditorViewImpl.this.dataProvider.getList().add(new Global(alias, className));
            }
        };
    }

    static interface GlobalsEditorViewBinder
    extends UiBinder<Widget, GlobalsEditorViewImpl> {
    }
}

