/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.client.handlers;

import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.screens.dtablexls.client.editor.URLHelper;
import org.drools.workbench.screens.dtablexls.client.handlers.FileExtensionSelector;
import org.drools.workbench.screens.dtablexls.client.resources.DecisionTableXLSResources;
import org.drools.workbench.screens.dtablexls.client.resources.i18n.DecisionTableXLSEditorConstants;
import org.drools.workbench.screens.dtablexls.client.type.DecisionTableXLSResourceType;
import org.drools.workbench.screens.dtablexls.client.type.DecisionTableXLSXResourceType;
import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.widget.AttachmentFileWidget;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewDecisionTableXLSHandler
extends DefaultNewResourceHandler {
    private PlaceManager placeManager;
    private DecisionTableXLSResourceType decisionTableXLSResourceType;
    private DecisionTableXLSXResourceType decisionTableXLSXResourceType;
    private BusyIndicatorView busyIndicatorView;
    private AttachmentFileWidget uploadWidget;
    private FileExtensionSelector fileExtensionSelector;

    public NewDecisionTableXLSHandler() {
    }

    @Inject
    public NewDecisionTableXLSHandler(PlaceManager placeManager, DecisionTableXLSResourceType decisionTableXLSResourceType, DecisionTableXLSXResourceType decisionTableXLSXResourceType, BusyIndicatorView busyIndicatorView) {
        this.placeManager = placeManager;
        this.decisionTableXLSResourceType = decisionTableXLSResourceType;
        this.decisionTableXLSXResourceType = decisionTableXLSXResourceType;
        this.busyIndicatorView = busyIndicatorView;
    }

    void setFileExtensionSelector(FileExtensionSelector fileExtensionSelector) {
        this.fileExtensionSelector = fileExtensionSelector;
    }

    void setUploadWidget(AttachmentFileWidget uploadWidget) {
        this.uploadWidget = uploadWidget;
    }

    @PostConstruct
    private void setupExtensions() {
        this.fileExtensionSelector = new FileExtensionSelector(new ResourceTypeDefinition[]{this.decisionTableXLSResourceType, this.decisionTableXLSXResourceType});
        this.uploadWidget = new AttachmentFileWidget(new String[]{this.decisionTableXLSResourceType.getSuffix(), this.decisionTableXLSXResourceType.getSuffix()});
        this.extensions.add(new Pair((Object)"File Type", (Object)this.fileExtensionSelector));
        this.extensions.add(new Pair((Object)DecisionTableXLSEditorConstants.INSTANCE.Upload(), (Object)this.uploadWidget));
    }

    public List<Pair<String, ? extends IsWidget>> getExtensions() {
        this.uploadWidget.reset();
        return super.getExtensions();
    }

    public String getDescription() {
        return DecisionTableXLSEditorConstants.INSTANCE.NewDecisionTableDescription();
    }

    public IsWidget getIcon() {
        return new Image(DecisionTableXLSResources.INSTANCE.images().typeXLSDecisionTable());
    }

    public ResourceTypeDefinition getResourceType() {
        return this.decisionTableXLSResourceType;
    }

    public void create(Package pkg, String baseFileName, final NewResourcePresenter presenter) {
        this.busyIndicatorView.showBusyIndicator(DecisionTableXLSEditorConstants.INSTANCE.Uploading());
        Path path = pkg.getPackageMainResourcesPath();
        String fileName = this.buildFileName(baseFileName, this.fileExtensionSelector.getResourceType());
        final Path newPath = PathFactory.newPathBasedOn((String)fileName, (String)(path.toURI() + "/" + this.encode(fileName)), (Path)path);
        this.uploadWidget.submit(path, fileName, URLHelper.getServletUrl(), new Command(){

            public void execute() {
                NewDecisionTableXLSHandler.this.busyIndicatorView.hideBusyIndicator();
                presenter.complete();
                NewDecisionTableXLSHandler.this.notifySuccess();
                NewDecisionTableXLSHandler.this.placeManager.goTo(newPath);
            }
        }, new Command(){

            public void execute() {
                NewDecisionTableXLSHandler.this.busyIndicatorView.hideBusyIndicator();
            }
        });
    }

    protected String encode(String fileName) {
        return URL.encode((String)fileName);
    }
}

