/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dtablexls.client.handlers;

import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.screens.dtablexls.client.editor.URLHelper;
import org.drools.workbench.screens.dtablexls.client.resources.DecisionTableXLSResources;
import org.drools.workbench.screens.dtablexls.client.resources.i18n.DecisionTableXLSEditorConstants;
import org.drools.workbench.screens.dtablexls.client.type.DecisionTableXLSResourceType;
import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.widget.AttachmentFileWidget;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewDecisionTableXLSHandler
extends DefaultNewResourceHandler {
    @Inject
    private PlaceManager placeManager;
    @Inject
    private DecisionTableXLSResourceType resourceType;
    @Inject
    private BusyIndicatorView busyIndicatorView;
    private AttachmentFileWidget uploadWidget;

    @PostConstruct
    private void setupExtensions() {
        this.uploadWidget = new AttachmentFileWidget(new String[]{this.resourceType.getSuffix()});
        this.extensions.add(new Pair((Object)DecisionTableXLSEditorConstants.INSTANCE.Upload(), (Object)this.uploadWidget));
    }

    public List<Pair<String, ? extends IsWidget>> getExtensions() {
        this.uploadWidget.reset();
        return super.getExtensions();
    }

    public String getDescription() {
        return DecisionTableXLSEditorConstants.INSTANCE.NewDecisionTableDescription();
    }

    public IsWidget getIcon() {
        return new Image(DecisionTableXLSResources.INSTANCE.images().typeXLSDecisionTable());
    }

    public ResourceTypeDefinition getResourceType() {
        return this.resourceType;
    }

    public void create(Package pkg, String baseFileName, final NewResourcePresenter presenter) {
        this.busyIndicatorView.showBusyIndicator(DecisionTableXLSEditorConstants.INSTANCE.Uploading());
        Path path = pkg.getPackageMainResourcesPath();
        String fileName = this.buildFileName(baseFileName, (ResourceTypeDefinition)this.resourceType);
        final Path newPath = PathFactory.newPathBasedOn((String)fileName, (String)URL.encode((String)(path.toURI() + "/" + fileName)), (Path)path);
        this.uploadWidget.submit(path, fileName, URLHelper.getServletUrl(), new Command(){

            public void execute() {
                NewDecisionTableXLSHandler.this.busyIndicatorView.hideBusyIndicator();
                presenter.complete();
                NewDecisionTableXLSHandler.this.notifySuccess();
                PathPlaceRequest place = new PathPlaceRequest(newPath);
                NewDecisionTableXLSHandler.this.placeManager.goTo((PlaceRequest)place);
            }
        }, new Command(){

            public void execute() {
                NewDecisionTableXLSHandler.this.busyIndicatorView.hideBusyIndicator();
            }
        });
    }
}

