/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dsltext.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.dsltext.client.editor.DSLEditorView;
import org.drools.workbench.screens.dsltext.client.type.DSLResourceType;
import org.drools.workbench.screens.dsltext.model.DSLTextEditorContent;
import org.drools.workbench.screens.dsltext.service.DSLTextEditorService;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="DSLEditor", supportedTypes={DSLResourceType.class})
public class DSLEditorPresenter
extends KieEditor {
    @Inject
    private Caller<DSLTextEditorService> dslTextEditorService;
    @Inject
    private Event<NotificationEvent> notification;
    private DSLEditorView view;
    @Inject
    private DSLResourceType type;

    @Inject
    public DSLEditorPresenter(DSLEditorView baseView) {
        super((KieEditorView)baseView);
        this.view = baseView;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.init(path, place, this.type);
    }

    protected void loadContent() {
        this.view.showLoading();
        ((DSLTextEditorService)this.dslTextEditorService.call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    private RemoteCallback<DSLTextEditorContent> getModelSuccessCallback() {
        return new RemoteCallback<DSLTextEditorContent>(){

            public void callback(DSLTextEditorContent content) {
                if (DSLEditorPresenter.this.versionRecordManager.getCurrentPath() == null) {
                    return;
                }
                DSLEditorPresenter.this.resetEditorPages(content.getOverview());
                DSLEditorPresenter.this.addSourcePage();
                DSLEditorPresenter.this.view.setContent(content.getModel());
                DSLEditorPresenter.this.view.hideBusyIndicator();
                DSLEditorPresenter.this.createOriginalHash(DSLEditorPresenter.this.view.getContent());
            }
        };
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                ((DSLTextEditorService)DSLEditorPresenter.this.dslTextEditorService.call((RemoteCallback)new RemoteCallback<List<ValidationMessage>>(){

                    public void callback(List<ValidationMessage> results) {
                        if (results == null || results.isEmpty()) {
                            DSLEditorPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                        } else {
                            ValidationPopup.showMessages(results);
                        }
                    }
                }, (ErrorCallback)new DefaultErrorCallback())).validate((Path)DSLEditorPresenter.this.versionRecordManager.getCurrentPath(), (Object)DSLEditorPresenter.this.view.getContent());
            }
        };
    }

    protected void save(String commitMessage) {
        ((DSLTextEditorService)this.dslTextEditorService.call(this.getSaveSuccessCallback(this.view.getContent().hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.view.getContent(), this.metadata, commitMessage);
    }

    public void onSourceTabSelected() {
        this.updateSource(this.view.getContent());
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.view.getContent());
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }
}

