/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dsltext.backend.server;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.compiler.lang.dsl.DSLMappingParseException;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.workbench.screens.dsltext.model.DSLTextEditorContent;
import org.drools.workbench.screens.dsltext.service.DSLTextEditorService;
import org.drools.workbench.screens.dsltext.type.DSLResourceTypeDefinition;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.builder.events.InvalidateDMOPackageCacheEvent;
import org.guvnor.common.services.shared.file.CopyService;
import org.guvnor.common.services.shared.file.DeleteService;
import org.guvnor.common.services.shared.file.RenameService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class DSLTextEditorServiceImpl
extends KieService
implements DSLTextEditorService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private KieProjectService projectService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<InvalidateDMOPackageCacheEvent> invalidateDMOPackageCache;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private DSLResourceTypeDefinition resourceTypeDefinition;

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, String content, String comment) {
        try {
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, content, new OpenOption[]{this.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, this.sessionInfo));
            return content;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public DSLTextEditorContent loadContent(org.uberfire.backend.vfs.Path path) {
        return new DSLTextEditorContent(this.load(path), this.loadOverview(path));
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, String content, Metadata metadata, String comment) {
        try {
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), content, this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.makeCommentedOption(comment)});
            this.invalidateDMOPackageCache.fire((Object)new InvalidateDMOPackageCacheEvent(resource));
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public boolean accepts(org.uberfire.backend.vfs.Path path) {
        return this.resourceTypeDefinition.accept(path);
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return this.validate(path, content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, String content) {
        return this.doValidation(content);
    }

    private List<ValidationMessage> doValidation(String content) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        DSLTokenizedMappingFile dslLoader = new DSLTokenizedMappingFile();
        try {
            if (!dslLoader.parseAndLoad((Reader)new StringReader(content))) {
                validationMessages.addAll(this.makeValidationMessages(dslLoader));
            }
            return validationMessages;
        }
        catch (IOException e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private List<ValidationMessage> makeValidationMessages(DSLTokenizedMappingFile dslLoader) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (KnowledgeBuilderResult o : dslLoader.getErrors()) {
            if (o instanceof DSLMappingParseException) {
                DSLMappingParseException dslMappingParseException = (DSLMappingParseException)o;
                messages.add(this.makeNewValidationMessage(dslMappingParseException));
                continue;
            }
            if (o instanceof Exception) {
                Exception e = (Exception)o;
                messages.add(this.makeNewValidationMessage(e));
                continue;
            }
            messages.add(this.makeNewValidationMessage(o));
        }
        return messages;
    }

    private ValidationMessage makeNewValidationMessage(DSLMappingParseException e) {
        ValidationMessage msg = new ValidationMessage();
        msg.setLevel(ValidationMessage.Level.ERROR);
        msg.setLine(e.getLine());
        msg.setText(e.getMessage());
        return msg;
    }

    private ValidationMessage makeNewValidationMessage(Exception e) {
        ValidationMessage msg = new ValidationMessage();
        msg.setLevel(ValidationMessage.Level.ERROR);
        msg.setText("Exception " + e.getClass() + " " + e.getMessage() + " " + e.getCause());
        return msg;
    }

    private ValidationMessage makeNewValidationMessage(Object o) {
        ValidationMessage msg = new ValidationMessage();
        msg.setLevel(ValidationMessage.Level.ERROR);
        msg.setText("Uncategorized error " + o);
        return msg;
    }
}

