/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.dsltext.backend.server.indexing;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.dsl.DSLMappingEntry;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.drools.workbench.screens.dsltext.type.DSLResourceTypeDefinition;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.kie.uberfire.metadata.engine.Indexer;
import org.kie.uberfire.metadata.model.KObject;
import org.kie.uberfire.metadata.model.KObjectKey;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.PackageDescrIndexVisitor;
import org.kie.workbench.common.services.refactoring.backend.server.util.KObjectUtil;
import org.kie.workbench.common.services.refactoring.model.index.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.model.index.Rule;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class DslFileIndexer
implements Indexer {
    private static final Logger logger = LoggerFactory.getLogger(DslFileIndexer.class);
    @Inject
    @Named(value="ioStrategy")
    protected IOService ioService;
    @Inject
    private DataModelService dataModelService;
    @Inject
    protected KieProjectService projectService;
    @Inject
    protected DSLResourceTypeDefinition dslType;

    public boolean supportsPath(Path path) {
        return this.dslType.accept(Paths.convert((Path)path));
    }

    public KObject toKObject(Path path) {
        KObject index = null;
        try {
            ArrayList<String> lhs = new ArrayList<String>();
            ArrayList<String> rhs = new ArrayList<String>();
            String dsl = this.ioService.readAllString(path);
            DSLTokenizedMappingFile dslLoader = new DSLTokenizedMappingFile();
            if (dslLoader.parseAndLoad((Reader)new StringReader(dsl))) {
                for (DSLMappingEntry e : dslLoader.getMapping().getEntries()) {
                    switch (e.getSection()) {
                        case CONDITION: {
                            lhs.add(e.getValuePattern());
                            break;
                        }
                        case CONSEQUENCE: {
                            rhs.add(e.getValuePattern());
                        }
                    }
                }
                DrlParser drlParser = new DrlParser();
                String drl = this.makeDrl(path, lhs, rhs);
                PackageDescr packageDescr = drlParser.parse(true, drl);
                if (packageDescr == null) {
                    logger.error("Unable to parse DRL for '" + path.toUri().toString() + "'.");
                    return index;
                }
                Project project = this.projectService.resolveProject(Paths.convert((Path)path));
                Package pkg = this.projectService.resolvePackage(Paths.convert((Path)path));
                DefaultIndexBuilder builder = new DefaultIndexBuilder(project, pkg){

                    public DefaultIndexBuilder addGenerator(IndexElementsGenerator generator) {
                        if (generator instanceof Rule) {
                            return this;
                        }
                        return super.addGenerator(generator);
                    }
                };
                ProjectDataModelOracle dmo = this.getProjectDataModelOracle(path);
                PackageDescrIndexVisitor visitor = new PackageDescrIndexVisitor(dmo, builder, packageDescr);
                visitor.visit();
                return KObjectUtil.toKObject((Path)path, (Set)builder.build());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return index;
    }

    public KObjectKey toKObjectKey(Path path) {
        return KObjectUtil.toKObjectKey((Path)path);
    }

    protected String getPackageName(Path path) {
        return this.projectService.resolvePackage(Paths.convert((Path)path)).getPackageName();
    }

    protected ProjectDataModelOracle getProjectDataModelOracle(Path path) {
        return this.dataModelService.getProjectDataModel(Paths.convert((Path)path));
    }

    private String makeDrl(Path path, List<String> lhs, List<String> rhs) {
        StringBuilder sb = new StringBuilder();
        String packageName = this.getPackageName(path);
        sb.append("package ").append(packageName).append("\n");
        sb.append("rule \"mock\"\n");
        sb.append("when\n");
        for (String e : lhs) {
            sb.append(e).append("\n");
        }
        sb.append("then\n");
        for (String e : rhs) {
            sb.append(e).append("\n");
        }
        sb.append("end\n");
        return sb.toString();
    }
}

