/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.common;

import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.TraitTypeEnum;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.traits.core.base.TraitHelperImpl;
import org.drools.traits.core.factmodel.TraitProxyImpl;

public class TraitDefaultFactHandle
extends DefaultFactHandle {
    public TraitDefaultFactHandle(long id, Object initialFact, long recency, WorkingMemoryEntryPoint wmEntryPoint) {
        this(id, TraitDefaultFactHandle.determineIdentityHashCode((Object)initialFact), initialFact, recency, wmEntryPoint, false);
    }

    public TraitDefaultFactHandle(long id, Object object, long recency, WorkingMemoryEntryPoint wmEntryPoint, boolean isTraitOrTraitable) {
        this(id, TraitDefaultFactHandle.determineIdentityHashCode((Object)object), object, recency, wmEntryPoint, isTraitOrTraitable);
    }

    public TraitDefaultFactHandle(long id, int identityHashCode, Object object, long recency, WorkingMemoryEntryPoint wmEntryPoint, boolean isTraitOrTraitable) {
        this.id = id;
        this.entryPointId = wmEntryPoint == null ? null : wmEntryPoint.getEntryPoint();
        this.wmEntryPoint = wmEntryPoint;
        this.recency = recency;
        this.setObject(object);
        this.identityHashCode = identityHashCode;
        this.traitType = this.determineTraitType(object, isTraitOrTraitable);
        if (wmEntryPoint != null) {
            this.setLinkedTuples(wmEntryPoint.getKnowledgeBase());
            this.wmEntryPoint = wmEntryPoint;
        } else {
            this.linkedTuples = new DefaultFactHandle.SingleLinkedTuples();
        }
    }

    public <K> K as(Class<K> klass) throws ClassCastException {
        if (klass.isAssignableFrom(this.object.getClass())) {
            return (K)this.object;
        }
        if (this.isTraitOrTraitable()) {
            TraitHelperImpl traitHelper = new TraitHelperImpl();
            K k = traitHelper.extractTrait((InternalFactHandle)this, klass);
            if (k != null) {
                return k;
            }
            throw new RuntimeException(String.format("Cannot trait to %s", klass));
        }
        throw new ClassCastException("The Handle's Object can't be cast to " + klass);
    }

    protected TraitTypeEnum determineTraitType(Object object, boolean isTraitOrTraitable) {
        if (isTraitOrTraitable) {
            return this.determineTraitType(object);
        }
        return TraitTypeEnum.NON_TRAIT;
    }

    public TraitTypeEnum determineTraitType(Object object) {
        if (object instanceof TraitProxyImpl) {
            return TraitTypeEnum.TRAIT;
        }
        if (object instanceof CoreWrapper) {
            return TraitTypeEnum.WRAPPED_TRAITABLE;
        }
        if (object instanceof TraitableBean) {
            return TraitTypeEnum.TRAITABLE;
        }
        return TraitTypeEnum.LEGACY_TRAITABLE;
    }
}

