/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.core.util.StringUtils;
import org.drools.template.parser.DefaultTemplateColumn;
import org.drools.template.parser.TemplateColumn;
import org.drools.template.parser.TemplateContainer;

public class RuleTemplate {
    private String name;
    private String contents;
    private List<TemplateColumn> columns;
    private TemplateContainer templateContainer;
    private boolean replaceOptionals;

    public RuleTemplate(String n, TemplateContainer tc) {
        this.name = n;
        this.columns = new ArrayList<TemplateColumn>();
        this.templateContainer = tc;
        this.replaceOptionals = true;
    }

    public RuleTemplate(String n, TemplateContainer tc, boolean replaceOptionals) {
        this.name = n;
        this.columns = new ArrayList<TemplateColumn>();
        this.templateContainer = tc;
        this.replaceOptionals = replaceOptionals;
    }

    public String getName() {
        return this.name;
    }

    public List<TemplateColumn> getColumns() {
        return this.columns;
    }

    public String getContents() {
        return this.contents;
    }

    public void addColumn(String columnString) {
        DefaultTemplateColumn column = new DefaultTemplateColumn(this.templateContainer, columnString);
        this.columns.add(column);
    }

    public void setContents(String contents) {
        this.contents = this.replaceOptionals(contents);
    }

    public String toString() {
        return "RuleTemplate[name," + this.name + "contents," + this.columns + "columns";
    }

    private String replaceOptionals(String contents) {
        if (!this.replaceOptionals) {
            return contents;
        }
        try {
            Pattern pattern = Pattern.compile("@\\{(.[^}]*)\\}");
            Collection<String> columns = this.getColumnNames();
            columns.add("row.rowNumber");
            BufferedReader reader = new BufferedReader(new StringReader(contents));
            String line = null;
            StringBuffer newLine = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                int optCols = 0;
                while (matcher.find()) {
                    String c = matcher.group(1);
                    if (columns.contains(c)) continue;
                    newLine.append("@if{").append(matcher.group(1)).append(" != null}");
                    ++optCols;
                }
                newLine.append(line);
                newLine.append(StringUtils.repeat((String)"@end{}", (int)optCols));
                newLine.append("\n");
            }
            return newLine.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<String> getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (TemplateColumn column : this.getColumns()) {
            columnNames.add(column.getName());
        }
        return columnNames;
    }
}

