/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.api.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;

public class Simulation {
    private final SimulationDescriptor simulationDescriptor = new SimulationDescriptor();
    private final List<Scenario> scenarios = new LinkedList<Scenario>();

    public List<Scenario> getUnmodifiableScenarios() {
        return Collections.unmodifiableList(this.scenarios);
    }

    public List<ScenarioWithIndex> getScenarioWithIndex() {
        return ScenarioSimulationSharedUtils.toScenarioWithIndex(this);
    }

    public void removeScenarioByIndex(int index) {
        this.scenarios.remove(index);
    }

    public void removeScenario(Scenario toRemove) {
        this.scenarios.remove(toRemove);
    }

    public SimulationDescriptor getSimulationDescriptor() {
        return this.simulationDescriptor;
    }

    public Scenario getScenarioByIndex(int index) {
        return this.scenarios.get(index);
    }

    public Scenario addScenario() {
        return this.addScenario(this.scenarios.size());
    }

    public Scenario addScenario(int index) {
        if (index < 0 || index > this.scenarios.size()) {
            throw new IllegalArgumentException("Index out of range " + index);
        }
        Scenario scenario = new Scenario(this.simulationDescriptor);
        this.scenarios.add(index, scenario);
        return scenario;
    }

    public void replaceScenario(int index, Scenario newScenario) {
        this.scenarios.set(index, newScenario);
    }

    public void removeFactMappingByIndex(int index) {
        this.clearScenarios(this.simulationDescriptor.getFactMappingByIndex(index));
        this.simulationDescriptor.removeFactMappingByIndex(index);
    }

    public void removeFactMapping(FactMapping toRemove) {
        this.clearScenarios(toRemove);
        this.simulationDescriptor.removeFactMapping(toRemove);
    }

    public Scenario cloneScenario(int sourceIndex, int targetIndex) {
        if (sourceIndex < 0 || sourceIndex >= this.scenarios.size()) {
            throw new IllegalArgumentException("SourceIndex out of range " + sourceIndex);
        }
        if (targetIndex < 0 || targetIndex > this.scenarios.size()) {
            throw new IllegalArgumentException("TargetIndex out of range " + targetIndex);
        }
        Scenario scenarioByIndex = this.getScenarioByIndex(sourceIndex);
        Scenario clonedScenario = scenarioByIndex.cloneScenario();
        this.scenarios.add(targetIndex, clonedScenario);
        return clonedScenario;
    }

    public void clear() {
        this.simulationDescriptor.clear();
        this.clearScenarios();
    }

    public void clearScenarios() {
        this.scenarios.clear();
    }

    public void resetErrors() {
        this.scenarios.forEach(Scenario::resetErrors);
    }

    public Simulation cloneSimulation() {
        Simulation toReturn = new Simulation();
        toReturn.getSimulationDescriptor().setType(this.simulationDescriptor.getType());
        toReturn.getSimulationDescriptor().setDmnFilePath(this.simulationDescriptor.getDmnFilePath());
        toReturn.getSimulationDescriptor().setDmoSession(this.simulationDescriptor.getDmoSession());
        List<FactMapping> originalFactMappings = this.simulationDescriptor.getUnmodifiableFactMappings();
        for (int i = 0; i < originalFactMappings.size(); ++i) {
            FactMapping originalFactMapping = originalFactMappings.get(i);
            toReturn.simulationDescriptor.addFactMapping(i, originalFactMapping);
        }
        this.scenarios.forEach(scenario -> toReturn.scenarios.add(scenario.cloneScenario()));
        return toReturn;
    }

    private void clearScenarios(FactMapping toRemove) {
        this.scenarios.forEach(e -> e.removeFactMappingValueByIdentifiers(toRemove.getFactIdentifier(), toRemove.getExpressionIdentifier()));
    }
}

