/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.drools.compiler.builder.conf.DecisionTableConfigurationImpl;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.drl.extensions.DecisionTableFactory;
import org.drools.drl.extensions.DecisionTableProvider;
import org.drools.model.codegen.ExecutableModelProject;
import org.drools.model.codegen.execmodel.CanonicalModelKieProject;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.api.conf.RuleConfig;
import org.drools.ruleunits.impl.InternalRuleUnit;
import org.drools.ruleunits.impl.NamedRuleUnitData;
import org.drools.ruleunits.impl.RuleUnitGenerationException;
import org.drools.ruleunits.impl.conf.RuleConfigImpl;
import org.drools.util.IoUtils;
import org.drools.util.JarUtils;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleUnitProviderImpl
implements RuleUnitProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleUnitProviderImpl.class);
    private static final boolean USE_EXEC_MODEL = true;
    private final Map<String, RuleUnit> ruleUnitMap = this.loadRuleUnits(Thread.currentThread().getContextClassLoader());

    public <T extends RuleUnitData> RuleUnit<T> getRuleUnit(T ruleUnitData) {
        String ruleUnitName = this.getRuleUnitName(ruleUnitData);
        RuleUnit ruleUnit = this.ruleUnitMap.get(ruleUnitName);
        if (ruleUnit != null) {
            return ruleUnit;
        }
        this.ruleUnitMap.putAll(this.generateRuleUnit(ruleUnitData));
        return this.ruleUnitMap.get(ruleUnitName);
    }

    protected <T extends RuleUnitData> Map<String, RuleUnit> generateRuleUnit(T ruleUnitData) {
        InternalKieModule kieModule = RuleUnitProviderImpl.createRuleUnitKieModule(ruleUnitData.getClass(), true);
        KieModuleKieProject kieModuleKieProject = RuleUnitProviderImpl.createRuleUnitKieProject(kieModule, true);
        return this.loadRuleUnits(kieModuleKieProject.getClassLoader());
    }

    private Map<String, RuleUnit> loadRuleUnits(ClassLoader classLoader) {
        HashMap<String, RuleUnit> map = new HashMap<String, RuleUnit>();
        ServiceLoader<RuleUnit> loader = ServiceLoader.load(RuleUnit.class, classLoader);
        for (RuleUnit impl : loader) {
            map.put(this.getRuleUnitName(((InternalRuleUnit)impl).getRuleUnitDataClass()), impl);
        }
        return map;
    }

    protected String getRuleUnitName(RuleUnitData ruleUnitData) {
        if (ruleUnitData instanceof NamedRuleUnitData) {
            return ((NamedRuleUnitData)ruleUnitData).getUnitName();
        }
        return this.getRuleUnitName(ruleUnitData.getClass());
    }

    protected String getRuleUnitName(Class<? extends RuleUnitData> ruleUnitDataClass) {
        return ruleUnitDataClass.getCanonicalName();
    }

    static InternalKieModule createRuleUnitKieModule(Class<?> unitClass, boolean useExecModel) {
        KieServices ks = KieServices.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        for (Resource drlResource : RuleUnitProviderImpl.ruleResourcesForUnitClass(ks, unitClass)) {
            kfs.write(drlResource);
        }
        return (InternalKieModule)ks.newKieBuilder(kfs).getKieModule(useExecModel ? ExecutableModelProject.class : DrlProject.class);
    }

    static KieModuleKieProject createRuleUnitKieProject(InternalKieModule kieModule, boolean useExecModel) {
        return useExecModel ? new CanonicalModelKieProject(kieModule, kieModule.getModuleClassLoader()) : new KieModuleKieProject(kieModule, kieModule.getModuleClassLoader());
    }

    private static Collection<Resource> ruleResourcesForUnitClass(KieServices ks, Class<?> unitClass) {
        String unitStatement = "unit " + unitClass.getSimpleName();
        HashSet<Resource> resources = new HashSet<Resource>();
        try {
            Enumeration<URL> urlEnumeration = unitClass.getClassLoader().getResources(unitClass.getPackageName().replace('.', '/'));
            while (urlEnumeration.hasMoreElements()) {
                String protocol;
                URL resourceUrl = urlEnumeration.nextElement();
                switch (protocol = resourceUrl.getProtocol()) {
                    case "file": {
                        RuleUnitProviderImpl.collectResourcesInFileSystem(ks, unitClass, unitStatement, resources, resourceUrl);
                        break;
                    }
                    case "jar": {
                        RuleUnitProviderImpl.collectResourcesInJar(ks, resources, unitClass, unitStatement, resourceUrl);
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuleUnitGenerationException("Exception while creating KieModule", e);
        }
        return resources;
    }

    private static void collectResourcesInFileSystem(KieServices ks, Class<?> unitClass, String unitStatement, Collection<Resource> resources, URL resourceUrl) {
        String path = resourceUrl.getPath();
        Optional.ofNullable(new File(path).listFiles()).stream().flatMap(Arrays::stream).filter(f -> RuleUnitProviderImpl.doesDrlContainUnit(f, unitStatement) || RuleUnitProviderImpl.doesXlsContainUnit(f, unitClass.getSimpleName())).map(arg_0 -> ((KieResources)ks.getResources()).newFileSystemResource(arg_0)).forEach(resource -> {
            LOGGER.debug("Found {} in {} unit", (Object)resource.getSourcePath(), (Object)unitClass.getSimpleName());
            resources.add((Resource)resource);
        });
    }

    private static boolean doesDrlContainUnit(File file, String unitStatement) {
        return file.getName().endsWith(".drl") && IoUtils.readFileAsString((File)file).contains(unitStatement);
    }

    private static boolean doesXlsContainUnit(File file, String unitName) {
        if (file.getName().endsWith(".drl.xls") || file.getName().endsWith(".drl.xlsx")) {
            DecisionTableProvider decisionTableProvider = DecisionTableFactory.getDecisionTableProvider();
            if (decisionTableProvider == null) {
                LOGGER.warn("decision table {} is found, but DecisionTableProvider implementation is not found in the classpath. Please add drools-decisiontables as a dependency", (Object)file.getName());
                return false;
            }
            Map dtableProperties = decisionTableProvider.loadPropertiesFromFile(file, (DecisionTableConfiguration)new DecisionTableConfigurationImpl());
            return RuleUnitProviderImpl.doDecisionTablePropertiesContainUnit(dtableProperties, unitName);
        }
        return false;
    }

    private static boolean doDecisionTablePropertiesContainUnit(Map<String, List<String[]>> dtableProperties, String unitName) {
        List<String[]> unitValues = dtableProperties.get("unit");
        return unitValues != null && unitValues.stream().anyMatch(valueArray -> ((String[])valueArray).length > 0 && valueArray[0] != null && valueArray[0].trim().equals(unitName));
    }

    private static void collectResourcesInJar(KieServices ks, Collection<Resource> resources, Class<?> unitClass, String unitStatement, URL resourceUrl) {
        String path = resourceUrl.getPath();
        int jarSuffixIndex = path.indexOf(".jar!/");
        String jarPath = path.substring(5, jarSuffixIndex + 4);
        String directoryPath = path.substring(jarSuffixIndex + 6);
        directoryPath = JarUtils.normalizeSpringBootResourceUrlPath((String)directoryPath);
        try (JarFile jarFile = new JarFile(new File(jarPath));){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!jarEntry.getName().startsWith(directoryPath + "/") || jarEntry.isDirectory() || !RuleUnitProviderImpl.doesDrlContainUnit(jarFile, jarEntry, unitStatement) && !RuleUnitProviderImpl.doesXlsContainUnit(jarFile, jarEntry, unitClass.getSimpleName())) continue;
                Resource resource = ks.getResources().newClassPathResource(jarEntry.getName(), unitClass.getClassLoader());
                LOGGER.debug("Found {} in {} unit", (Object)resource.getSourcePath(), (Object)unitClass.getSimpleName());
                resources.add(resource);
            }
        }
        catch (IOException e) {
            throw new RuleUnitGenerationException("Exception while collecting resources in a jar file", e);
        }
    }

    private static boolean doesDrlContainUnit(JarFile jarFile, JarEntry jarEntry, String unitStatement) {
        return jarEntry.getName().endsWith(".drl") && IoUtils.readJarEntryAsString((JarFile)jarFile, (JarEntry)jarEntry).contains(unitStatement);
    }

    private static boolean doesXlsContainUnit(JarFile jarFile, JarEntry jarEntry, String unitName) {
        if (jarEntry.getName().endsWith(".drl.xls") || jarEntry.getName().endsWith(".drl.xlsx")) {
            boolean bl;
            block10: {
                DecisionTableProvider decisionTableProvider = DecisionTableFactory.getDecisionTableProvider();
                if (decisionTableProvider == null) {
                    LOGGER.warn("decision table {} is found, but DecisionTableProvider implementation is not found in the classpath. Please add drools-decisiontables as a dependency", (Object)jarEntry.getName());
                    return false;
                }
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                try {
                    Map dtableProperties = decisionTableProvider.loadPropertiesFromInputStream(inputStream, (DecisionTableConfiguration)new DecisionTableConfigurationImpl());
                    bl = RuleUnitProviderImpl.doDecisionTablePropertiesContainUnit(dtableProperties, unitName);
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                inputStream.close();
            }
            return bl;
        }
        return false;
    }

    public RuleConfig newRuleConfig() {
        return new RuleConfigImpl();
    }

    public <T extends RuleUnitData> int invalidateRuleUnits(Class<T> ruleUnitDataClass) {
        if (NamedRuleUnitData.class.isAssignableFrom(ruleUnitDataClass)) {
            List<String> invalidateKeys = this.ruleUnitMap.entrySet().stream().filter(entry -> RuleUnitProviderImpl.hasSameRuleUnitDataClass((RuleUnit)entry.getValue(), ruleUnitDataClass)).map(Map.Entry::getKey).collect(Collectors.toList());
            invalidateKeys.forEach(this.ruleUnitMap::remove);
            return invalidateKeys.size();
        }
        String ruleUnitName = this.getRuleUnitName(ruleUnitDataClass);
        RuleUnit remove = this.ruleUnitMap.remove(ruleUnitName);
        return remove == null ? 0 : 1;
    }

    private static <T extends RuleUnitData> boolean hasSameRuleUnitDataClass(RuleUnit ruleUnit, Class<T> ruleUnitDataClass) {
        if (ruleUnit instanceof InternalRuleUnit) {
            return ((InternalRuleUnit)ruleUnit).getRuleUnitDataClass().equals(ruleUnitDataClass);
        }
        return false;
    }
}

