/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl.sessions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.EntryPointsManager;
import org.drools.core.QueryResultsImpl;
import org.drools.core.SessionConfiguration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.CalendarsImpl;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.InternalViewChangedEventListener;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.base.NonCloningQueryViewListener;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.ConcurrentNodeMemories;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NodeMemories;
import org.drools.core.common.PhreakPropagationContext;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.event.RuleEventListenerSupport;
import org.drools.core.event.RuleRuntimeEventSupport;
import org.drools.core.impl.ActivationsManagerImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.accessor.FactHandleFactory;
import org.drools.core.rule.accessor.GlobalResolver;
import org.drools.core.time.TimerService;
import org.drools.core.time.TimerServiceFactory;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.time.SessionClock;

public class RuleUnitExecutorImpl
implements ReteEvaluator {
    private final RuleRuntimeEventSupport ruleRuntimeEventSupport = new RuleRuntimeEventSupport();
    private final AtomicLong propagationIdCounter = new AtomicLong(1L);
    private final RuleBase ruleBase;
    private final SessionConfiguration sessionConfiguration;
    private final FactHandleFactory handleFactory;
    private final NodeMemories nodeMemories;
    private final ActivationsManager activationsManager;
    private final EntryPointsManager entryPointsManager;
    private final RuleEventListenerSupport ruleEventListenerSupport = new RuleEventListenerSupport();
    private final GlobalResolver globalResolver = new MapGlobalResolver();
    private final TimerService timerService;
    private Calendars calendars;

    public RuleUnitExecutorImpl(RuleBase knowledgeBase) {
        this(knowledgeBase, knowledgeBase.getSessionConfiguration());
    }

    public RuleUnitExecutorImpl(RuleBase knowledgeBase, SessionConfiguration sessionConfiguration) {
        this.ruleBase = knowledgeBase;
        this.sessionConfiguration = sessionConfiguration;
        this.handleFactory = knowledgeBase.newFactHandleFactory();
        this.nodeMemories = new ConcurrentNodeMemories(this.ruleBase);
        this.activationsManager = new ActivationsManagerImpl((ReteEvaluator)this);
        this.entryPointsManager = RuntimeComponentFactory.get().getEntryPointFactory().createEntryPointsManager((ReteEvaluator)this);
        this.timerService = TimerServiceFactory.getTimerService((SessionConfiguration)sessionConfiguration);
        this.initInitialFact(this.ruleBase);
    }

    private void initInitialFact(RuleBase kBase) {
        WorkingMemoryEntryPoint defaultEntryPoint = this.entryPointsManager.getDefaultEntryPoint();
        InternalFactHandle handle = this.getFactHandleFactory().newInitialFactHandle(defaultEntryPoint);
        ObjectTypeNode otn = (ObjectTypeNode)defaultEntryPoint.getEntryPointNode().getObjectTypeNodes().get(ClassObjectType.InitialFact_ObjectType);
        if (otn != null) {
            PropagationContextFactory ctxFact = RuntimeComponentFactory.get().getPropagationContextFactory();
            PropagationContext pctx = ctxFact.createPropagationContext(0L, PropagationContext.Type.INSERTION, null, null, handle, defaultEntryPoint.getEntryPoint(), null);
            otn.assertInitialFact(handle, pctx, (ReteEvaluator)this);
        }
    }

    public ActivationsManager getActivationsManager() {
        return this.activationsManager;
    }

    public RuleBase getKnowledgeBase() {
        return this.ruleBase;
    }

    public Collection<? extends EntryPoint> getEntryPoints() {
        return this.entryPointsManager.getEntryPoints();
    }

    public WorkingMemoryEntryPoint getEntryPoint(String name) {
        return this.entryPointsManager.getEntryPoint(name);
    }

    public <T extends Memory> T getNodeMemory(MemoryFactory<T> node) {
        return (T)this.nodeMemories.getNodeMemory(node, (ReteEvaluator)this);
    }

    public GlobalResolver getGlobalResolver() {
        return this.globalResolver;
    }

    public FactHandleFactory getFactHandleFactory() {
        return this.handleFactory;
    }

    public InternalFactHandle getFactHandle(Object object) {
        return (InternalFactHandle)this.entryPointsManager.getDefaultEntryPoint().getFactHandle(object);
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public void addPropagation(PropagationEntry propagationEntry, boolean register) {
        try {
            if (register) {
                this.startOperation();
            }
            this.activationsManager.addPropagation(propagationEntry);
        }
        finally {
            if (register) {
                this.endOperation();
            }
        }
    }

    public long getNextPropagationIdCounter() {
        return this.propagationIdCounter.incrementAndGet();
    }

    public SessionConfiguration getSessionConfiguration() {
        return this.sessionConfiguration;
    }

    public RuleEventListenerSupport getRuleEventSupport() {
        return this.ruleEventListenerSupport;
    }

    public RuleRuntimeEventSupport getRuleRuntimeEventSupport() {
        return this.ruleRuntimeEventSupport;
    }

    public Calendars getCalendars() {
        if (this.calendars == null) {
            this.calendars = new CalendarsImpl();
        }
        return this.calendars;
    }

    public SessionClock getSessionClock() {
        return (SessionClock)this.timerService;
    }

    public int fireAllRules() {
        return this.fireAllRules(null, -1);
    }

    public int fireAllRules(int fireLimit) {
        return this.fireAllRules(null, fireLimit);
    }

    public int fireAllRules(AgendaFilter agendaFilter) {
        return this.fireAllRules(agendaFilter, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        try {
            this.startOperation();
            int n = this.activationsManager.fireAllRules(agendaFilter, fireLimit);
            return n;
        }
        finally {
            this.endOperation();
        }
    }

    public FactHandle insert(Object object) {
        return this.getDefaultEntryPoint().insert(object);
    }

    public void dispose() {
        for (WorkingMemoryEntryPoint ep : this.entryPointsManager.getEntryPoints()) {
            ep.dispose();
        }
        this.ruleRuntimeEventSupport.clear();
        this.ruleEventListenerSupport.clear();
        this.timerService.shutdown();
    }

    public QueryResults getQueryResults(String queryName, Object ... arguments) {
        this.activationsManager.flushPropagations();
        DroolsQuery queryObject = new DroolsQuery(queryName, arguments, (InternalViewChangedEventListener)new NonCloningQueryViewListener(), false);
        InternalFactHandle handle = this.handleFactory.newFactHandle((Object)queryObject, null, (ReteEvaluator)this, this.getDefaultEntryPoint());
        PhreakPropagationContext pCtx = new PhreakPropagationContext(this.getNextPropagationIdCounter(), PropagationContext.Type.INSERTION, null, null, handle, this.getDefaultEntryPointId());
        PropagationEntry.ExecuteQuery executeQuery = new PropagationEntry.ExecuteQuery(queryName, queryObject, handle, (PropagationContext)pCtx, false);
        this.addPropagation((PropagationEntry)executeQuery);
        TerminalNode[] terminalNodes = (TerminalNode[])executeQuery.getResult();
        ArrayList<Map> decls = new ArrayList<Map>();
        if (terminalNodes != null) {
            for (TerminalNode node : terminalNodes) {
                decls.add(node.getSubRule().getOuterDeclarations());
            }
        }
        this.handleFactory.destroyFactHandle(handle);
        return new QueryResultsImpl(queryObject.getQueryResultCollector().getResults(), decls.toArray(new Map[decls.size()]), (ReteEvaluator)this, queryObject.getQuery() != null ? queryObject.getQuery().getParameters() : new Declaration[]{});
    }
}

