/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.ruleunits.api.DataSource;
import org.drools.ruleunits.api.RuleUnit;
import org.drools.ruleunits.api.RuleUnitConfig;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.conf.Clock;
import org.drools.ruleunits.api.conf.ClockType;
import org.drools.ruleunits.api.conf.EventProcessing;
import org.drools.ruleunits.api.conf.EventProcessingType;
import org.drools.ruleunits.api.conf.SessionsPool;
import org.drools.ruleunits.impl.AbstractRuleUnitDescription;
import org.drools.ruleunits.impl.AssignableChecker;
import org.drools.ruleunits.impl.SimpleRuleUnitVariable;
import org.drools.wiring.api.util.ClassUtils;

public class ReflectiveRuleUnitDescription
extends AbstractRuleUnitDescription {
    private final Class<? extends RuleUnitData> ruleUnitClass;
    private final AssignableChecker assignableChecker;

    public ReflectiveRuleUnitDescription(InternalKnowledgePackage pkg, Class<? extends RuleUnitData> ruleUnitClass) {
        this.ruleUnitClass = ruleUnitClass;
        this.assignableChecker = AssignableChecker.create(ruleUnitClass.getClassLoader());
        this.indexUnitVars();
        this.setConfig(ReflectiveRuleUnitDescription.loadConfig(ruleUnitClass));
    }

    public String getCanonicalName() {
        return this.ruleUnitClass.getCanonicalName();
    }

    public String getSimpleName() {
        return this.ruleUnitClass.getSimpleName();
    }

    public String getPackageName() {
        Package aPackage = this.ruleUnitClass.getPackage();
        if (aPackage == null) {
            String canonicalName = this.ruleUnitClass.getCanonicalName();
            return canonicalName.substring(0, canonicalName.length() - this.getSimpleName().length() - 1);
        }
        return aPackage.getName();
    }

    public Class<?> getRuleUnitClass() {
        return this.ruleUnitClass;
    }

    public String getRuleUnitName() {
        return this.ruleUnitClass.getName();
    }

    private void indexUnitVars() {
        for (Method m : this.ruleUnitClass.getMethods()) {
            String id;
            if (m.getDeclaringClass() == RuleUnit.class || m.getParameterCount() != 0 || (id = ClassUtils.getter2property((String)m.getName())) == null || id.equals("class")) continue;
            Class<?> parametricType = this.getUnitVarType(m);
            Method setter = ClassUtils.getSetter(m.getDeclaringClass(), (String)id, (Class[])new Class[]{m.getReturnType()});
            this.putRuleUnitVariable(new SimpleRuleUnitVariable(id, m.getReturnType(), parametricType, setter != null));
        }
    }

    private Class<?> getUnitVarType(Method m) {
        Class<?> returnClass = m.getReturnType();
        if (returnClass.isArray()) {
            return returnClass.getComponentType();
        }
        if (this.assignableChecker.isAssignableFrom(DataSource.class, returnClass)) {
            return this.getParametricType(m);
        }
        if (Iterable.class.isAssignableFrom(returnClass)) {
            return this.getParametricType(m);
        }
        return null;
    }

    public AssignableChecker getAssignableChecker() {
        return this.assignableChecker;
    }

    private Class<?> getParametricType(Method m) {
        Type returnType = m.getGenericReturnType();
        return returnType instanceof ParameterizedType ? (Class)((ParameterizedType)returnType).getActualTypeArguments()[0] : Object.class;
    }

    private static RuleUnitConfig loadConfig(Class<? extends RuleUnitData> ruleUnitClass) {
        Optional<EventProcessing> eventAnn = Optional.ofNullable(ruleUnitClass.getAnnotation(EventProcessing.class));
        Optional<Clock> clockAnn = Optional.ofNullable(ruleUnitClass.getAnnotation(Clock.class));
        Optional<SessionsPool> sessionsPoolAnn = Optional.ofNullable(ruleUnitClass.getAnnotation(SessionsPool.class));
        return new RuleUnitConfig((EventProcessingType)eventAnn.map(EventProcessing::value).orElse(null), (ClockType)clockAnn.map(Clock::value).orElse(null), (Integer)sessionsPoolAnn.map(SessionsPool::value).orElse(null));
    }
}

