/*
 * Decompiled with CFR 0.152.
 */
package org.drools.osgi.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class OsgiKieModule
extends AbstractKieModule {
    private final Bundle bundle;
    private Collection<String> fileNames;
    private final long creationTimestamp = System.currentTimeMillis();

    private OsgiKieModule(ReleaseId releaseId, KieModuleModel kModuleModel, Bundle bundle) {
        super(releaseId, kModuleModel);
        this.bundle = bundle;
    }

    public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    public boolean isAvailable(String pResourceName) {
        return this.fileNames.contains(pResourceName);
    }

    public byte[] getBytes(String pResourceName) {
        pResourceName = "/" + pResourceName;
        URL url = this.bundle.getResource(pResourceName);
        return url == null ? null : OsgiKieModule.readUrlAsBytes(url);
    }

    public Collection<String> getFileNames() {
        if (this.fileNames != null) {
            return this.fileNames;
        }
        this.fileNames = new ArrayList<String>();
        Enumeration e = this.bundle.findEntries("", "*", true);
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            String path = url.getPath();
            if (path.endsWith("/")) continue;
            this.fileNames.add(path.substring(1, path.length()));
        }
        return this.fileNames;
    }

    public File getFile() {
        throw new UnsupportedOperationException();
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public static OsgiKieModule create(URL url) {
        KieModuleModel kieProject = KieModuleModelImpl.fromXML((URL)url);
        Bundle bundle = OsgiKieModule.getBundle(url.toString());
        if (bundle != null) {
            String pomProperties = OsgiKieModule.getPomProperties(bundle);
            ReleaseId releaseId = ReleaseIdImpl.fromPropertiesString((String)pomProperties);
            return new OsgiKieModule(releaseId, kieProject, bundle);
        }
        throw new RuntimeException("Bundle does not exist or no retrieved for this URL :  " + url);
    }

    public static OsgiKieModule create(URL url, ReleaseId releaseId, KieModuleModel kieProject) {
        Bundle bundle = OsgiKieModule.getBundle(url.toString());
        if (bundle != null) {
            return new OsgiKieModule(releaseId, kieProject, bundle);
        }
        throw new RuntimeException("Bundle does not exist or no retrieved for this URL :  " + url);
    }

    private static String getPomProperties(Bundle bundle) {
        Enumeration e = bundle.findEntries("META-INF/maven", "pom.properties", true);
        if (!e.hasMoreElements()) {
            throw new RuntimeException("Cannot find pom.properties file in bundle " + bundle);
        }
        return OsgiKieModule.readUrlAsString((URL)e.nextElement());
    }

    private static Bundle getBundle(String url) {
        String urlString = url.toString();
        String id = urlString.substring("bundle://".length(), urlString.indexOf(46));
        long bundleId = Long.parseLong(id);
        return FrameworkUtil.getBundle(OsgiKieModule.class).getBundleContext().getBundle(bundleId);
    }

    private static String readUrlAsString(URL url) {
        return new String(OsgiKieModule.readUrlAsBytes(url));
    }

    private static byte[] readUrlAsBytes(URL url) {
        InputStream is = null;
        try {
            is = url.openStream();
            byte[] byArray = IoUtils.readBytesFromInputStream((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

