/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.drools.core.util.PropertyReactivityUtil;
import org.drools.util.MethodUtils;

public class ClassUtil {
    private static final Map<Class<?>, List<String>> ACCESSIBLE_PROPS_CACHE = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, List<String>> ACCESSIBLE_PROPS_CACHE_INCLUDING_NON_GETTER = Collections.synchronizedMap(new WeakHashMap());

    public static String asJavaSourceName(Class<?> clazz) {
        return clazz.getCanonicalName().replace('.', '_');
    }

    public static Class<?> javaSourceNameToClass(String javaSourceName) throws ClassNotFoundException {
        String fqcn = javaSourceName.replace('_', '.');
        return Class.forName(fqcn);
    }

    public static List<String> getAccessibleProperties(Class<?> clazz) {
        return ACCESSIBLE_PROPS_CACHE.computeIfAbsent(clazz, PropertyReactivityUtil::getAccessibleProperties);
    }

    public static boolean isAccessiblePropertiesIncludingNonGetterValueMethod(Class<?> clazz, String prop) {
        return ClassUtil.getAccessiblePropertiesIncludingNonGetterValueMethod(clazz).contains(prop);
    }

    public static List<String> getAccessiblePropertiesIncludingNonGetterValueMethod(Class<?> clazz) {
        return ACCESSIBLE_PROPS_CACHE_INCLUDING_NON_GETTER.computeIfAbsent(clazz, PropertyReactivityUtil::getAccessiblePropertiesIncludingNonGetterValueMethod);
    }

    public static Type boxTypePrimitive(Type type) {
        if (type instanceof Class) {
            return MethodUtils.boxPrimitive((Class)((Class)type));
        }
        return type;
    }

    public static boolean isAssignableFrom(Type from, Type to) {
        Class<?> toClass;
        Class<?> fromClass = ClassUtil.toRawClass(from);
        return fromClass.isAssignableFrom(toClass = ClassUtil.toRawClass(to)) || MethodUtils.areBoxingCompatible(fromClass, toClass);
    }

    public static Class<?> toNonPrimitiveType(Class<?> c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        return c;
    }

    public static Class<?> toRawClass(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtil.toRawClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        throw new UnsupportedOperationException("Unknown type " + type);
    }

    public static Type getTypeArgument(Type genericType, int index) {
        return genericType instanceof ParameterizedType ? ((ParameterizedType)genericType).getActualTypeArguments()[index] : Object.class;
    }
}

