/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jpdl.instance.node;

import org.drools.jpdl.core.node.Decision;
import org.drools.jpdl.instance.node.JpdlNodeInstance;
import org.drools.workflow.instance.NodeInstance;
import org.jbpm.JbpmException;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.DecisionCondition;
import org.jbpm.graph.node.DecisionHandler;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;

public class DecisionInstance
extends JpdlNodeInstance {
    private static final long serialVersionUID = 1L;

    public Decision getDecision() {
        return (Decision)this.getNode();
    }

    public void execute(NodeInstance from, String type) {
        String transitionName = null;
        try {
            Delegation decisionDelegation = this.getDecision().getDecisionDelegation();
            if (decisionDelegation != null) {
                DecisionHandler decisionHandler = (DecisionHandler)decisionDelegation.instantiate();
                transitionName = decisionHandler.decide((ExecutionContext)new JpdlNodeInstance.JpdlExecutionContext());
            } else if (this.getDecision().getDecisionExpression() != null) {
                String decisionExpression = this.getDecision().getDecisionExpression();
                Object result = JbpmExpressionEvaluator.evaluate((String)decisionExpression, (ExecutionContext)new JpdlNodeInstance.JpdlExecutionContext());
                if (result == null) {
                    throw new JbpmException("decision expression '" + decisionExpression + "' returned null");
                }
                transitionName = result.toString();
            } else if (this.getDecision().getDecisionConditions() != null) {
                for (DecisionCondition decisionCondition : this.getDecision().getDecisionConditions()) {
                    Object result = JbpmExpressionEvaluator.evaluate((String)decisionCondition.getExpression(), (ExecutionContext)new JpdlNodeInstance.JpdlExecutionContext());
                    if (!Boolean.TRUE.equals(result)) continue;
                    transitionName = decisionCondition.getTransitionName();
                    break;
                }
            }
            if (transitionName == null) {
                this.leave();
            } else {
                this.leave(transitionName);
            }
        }
        catch (Exception exception) {
            this.raiseException(exception);
        }
    }
}

