/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jpdl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.definition.process.Node;
import org.drools.jpdl.JpdlProcessValidator;
import org.drools.jpdl.core.JpdlConnection;
import org.drools.jpdl.core.JpdlProcess;
import org.drools.jpdl.core.node.Decision;
import org.drools.jpdl.core.node.EndState;
import org.drools.jpdl.core.node.Fork;
import org.drools.jpdl.core.node.Join;
import org.drools.jpdl.core.node.JpdlNode;
import org.drools.jpdl.core.node.MailNode;
import org.drools.jpdl.core.node.ProcessState;
import org.drools.jpdl.core.node.StartState;
import org.drools.jpdl.core.node.State;
import org.drools.jpdl.core.node.SuperState;
import org.drools.jpdl.core.node.TaskNode;
import org.drools.process.core.Context;
import org.drools.process.core.ParameterDefinition;
import org.drools.process.core.context.swimlane.Swimlane;
import org.drools.process.core.context.swimlane.SwimlaneContext;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.StringDataType;
import org.drools.process.core.impl.ParameterDefinitionImpl;
import org.drools.process.core.validation.ProcessValidationError;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.taskmgmt.def.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpdlParser {
    private static final Set<ParameterDefinition> EMAIL_PARAMETER_DEFINITIONS = new HashSet<ParameterDefinition>();
    private static final Pattern MAIL_TEMPLATE_PATTERN = Pattern.compile("<template>(.*)</template>", 32);
    private static final Pattern MAIL_ACTORS_PATTERN = Pattern.compile("<actors>(.*)</actors>", 32);
    private static final Pattern MAIL_TO_PATTERN = Pattern.compile("<to>(.*)</to>", 32);
    private static final Pattern MAIL_SUBJECT_PATTERN = Pattern.compile("<subject>(.*)</subject>", 32);
    private static final Pattern MAIL_TEXT_PATTERN = Pattern.compile("<text>(.*)</text>", 32);
    private int nodeId = 0;
    private ProcessValidationError[] errors;

    public JpdlProcess loadJpdlProcess(String name) {
        ProcessDefinition processDefinition = ProcessDefinition.parseXmlResource((String)name);
        return this.loadJpdlProcess(processDefinition);
    }

    public JpdlProcess loadJpdlProcess(ProcessDefinition processDefinition) {
        JpdlProcess process = new JpdlProcess();
        process.setId(processDefinition.getName());
        process.setName(processDefinition.getName());
        process.setPackageName("org.drools");
        SwimlaneContext swimlaneContext = (SwimlaneContext)process.getDefaultContext("SwimlaneScope");
        process.setDefaultContext((Context)swimlaneContext);
        org.jbpm.graph.def.Node startState = processDefinition.getStartState();
        String startStateName = startState == null ? null : startState.getName();
        List nodes = processDefinition.getNodes();
        HashMap<org.jbpm.graph.def.Node, org.drools.workflow.core.Node> mapping = new HashMap<org.jbpm.graph.def.Node, org.drools.workflow.core.Node>();
        for (org.jbpm.graph.def.Node jPDLnode : nodes) {
            JpdlNode node = this.classifyNode(processDefinition, jPDLnode, swimlaneContext);
            if (node == null) {
                throw new IllegalArgumentException("Unknown node type: " + jPDLnode.getClass().getName() + " " + jPDLnode);
            }
            this.setDefaultNodeProperties(jPDLnode, node);
            node.setId(++this.nodeId);
            mapping.put(jPDLnode, (org.drools.workflow.core.Node)node);
            process.addNode((Node)node);
            if (startStateName == null || !startStateName.equals(node.getName())) continue;
            process.setStartState((Node)node);
        }
        this.generateConnections(mapping);
        this.errors = JpdlProcessValidator.getInstance().validateProcess(process);
        return process;
    }

    private JpdlNode classifyNode(ProcessDefinition processDefinition, org.jbpm.graph.def.Node jPDLnode, SwimlaneContext swimlaneContext) {
        JpdlNode node = null;
        if (jPDLnode instanceof org.jbpm.graph.node.StartState) {
            StartState newNode = new StartState();
            Task task = processDefinition.getTaskMgmtDefinition().getStartTask();
            if (task != null) {
                String swimlaneName;
                newNode.setTask(task);
                org.jbpm.taskmgmt.def.Swimlane jPDLswimlane = task.getSwimlane();
                if (jPDLswimlane != null && swimlaneContext.getSwimlane(swimlaneName = jPDLswimlane.getName()) == null) {
                    Swimlane swimlane = new Swimlane();
                    swimlane.setName(swimlaneName);
                    swimlane.setActorId(jPDLswimlane.getActorIdExpression());
                    swimlaneContext.addSwimlane(swimlane);
                }
            }
            node = newNode;
        } else if (jPDLnode instanceof org.jbpm.graph.node.EndState) {
            node = new EndState();
        } else if (org.jbpm.graph.def.Node.class.equals(jPDLnode.getClass())) {
            JpdlNode newNode = new JpdlNode();
            this.setDefaultNodeProperties(jPDLnode, newNode);
            node = newNode;
        } else if (jPDLnode instanceof org.jbpm.graph.node.Fork) {
            org.jbpm.graph.node.Fork jPDLfork = (org.jbpm.graph.node.Fork)jPDLnode;
            Fork newNode = new Fork();
            newNode.setScript(jPDLfork.getScript());
            node = newNode;
        } else if (jPDLnode instanceof org.jbpm.graph.node.Join) {
            org.jbpm.graph.node.Join jPDLjoin = (org.jbpm.graph.node.Join)jPDLnode;
            Join newNode = new Join();
            newNode.setDiscriminator(jPDLjoin.isDiscriminator());
            newNode.setTokenNames(jPDLjoin.getTokenNames());
            newNode.setScript(jPDLjoin.getScript());
            newNode.setNOutOfM(jPDLjoin.getNOutOfM());
            node = newNode;
        } else if (jPDLnode instanceof org.jbpm.graph.node.MailNode) {
            String config = jPDLnode.getAction().getActionDelegation().getConfiguration();
            MailNode newNode = new MailNode();
            Matcher matcher = MAIL_TEMPLATE_PATTERN.matcher(config);
            if (matcher.find()) {
                newNode.setTemplate(matcher.group(1));
            }
            if ((matcher = MAIL_ACTORS_PATTERN.matcher(config)).find()) {
                newNode.setActors(matcher.group(1));
            }
            if ((matcher = MAIL_TO_PATTERN.matcher(config)).find()) {
                newNode.setToEmail(matcher.group(1));
            }
            if ((matcher = MAIL_SUBJECT_PATTERN.matcher(config)).find()) {
                newNode.setSubject(matcher.group(1));
            }
            if ((matcher = MAIL_TEXT_PATTERN.matcher(config)).find()) {
                newNode.setText(matcher.group(1));
            }
            node = newNode;
        } else if (jPDLnode instanceof org.jbpm.graph.node.Decision) {
            org.jbpm.graph.node.Decision jPDLdecision = (org.jbpm.graph.node.Decision)jPDLnode;
            Decision newNode = new Decision();
            newNode.setDecisionConditions(jPDLdecision.getDecisionConditions());
            node = newNode;
        } else if (jPDLnode instanceof org.jbpm.graph.node.ProcessState) {
            org.jbpm.graph.node.ProcessState jPDLprocessState = (org.jbpm.graph.node.ProcessState)jPDLnode;
            ProcessState newNode = new ProcessState();
            ProcessDefinition subProcessDefinition = jPDLprocessState.getSubProcessDefinition();
            if (subProcessDefinition != null) {
                newNode.setSubProcessName(subProcessDefinition.getName());
            }
            node = newNode;
        } else if (jPDLnode instanceof org.jbpm.graph.def.SuperState) {
            org.jbpm.graph.def.SuperState jPDLsuperState = (org.jbpm.graph.def.SuperState)jPDLnode;
            SuperState newNode = new SuperState();
            List nodes = jPDLsuperState.getNodes();
            HashMap<org.jbpm.graph.def.Node, org.drools.workflow.core.Node> mapping = new HashMap<org.jbpm.graph.def.Node, org.drools.workflow.core.Node>();
            for (org.jbpm.graph.def.Node nodeInsideSuperState : nodes) {
                JpdlNode nodeToAdd = this.classifyNode(processDefinition, nodeInsideSuperState, swimlaneContext);
                if (nodeToAdd == null) {
                    throw new IllegalArgumentException("Unknown node type: " + jPDLnode.getClass().getName() + " " + jPDLnode);
                }
                this.setDefaultNodeProperties(nodeInsideSuperState, nodeToAdd);
                nodeToAdd.setId(++this.nodeId);
                mapping.put(nodeInsideSuperState, (org.drools.workflow.core.Node)nodeToAdd);
                newNode.addNode(nodeToAdd);
            }
            this.generateConnections(mapping);
            node = newNode;
        } else if (jPDLnode instanceof org.jbpm.graph.node.TaskNode) {
            org.jbpm.graph.node.TaskNode jPDLtaskNode = (org.jbpm.graph.node.TaskNode)jPDLnode;
            TaskNode newNode = new TaskNode();
            Set tasks = jPDLtaskNode.getTasks();
            newNode.setTasks(tasks);
            newNode.setSignal(jPDLtaskNode.getSignal());
            newNode.setCreateTasks(jPDLtaskNode.getCreateTasks());
            newNode.setEndTasks(jPDLtaskNode.isEndTasks());
            for (Task task : tasks) {
                String swimlaneName;
                org.jbpm.taskmgmt.def.Swimlane jPDLswimlane = task.getSwimlane();
                if (jPDLswimlane == null || swimlaneContext.getSwimlane(swimlaneName = jPDLswimlane.getName()) != null) continue;
                Swimlane swimlane = new Swimlane();
                swimlane.setName(swimlaneName);
                swimlane.setActorId(jPDLswimlane.getActorIdExpression());
                swimlaneContext.addSwimlane(swimlane);
            }
            node = newNode;
        } else if (jPDLnode instanceof org.jbpm.graph.node.State) {
            node = new State();
        }
        return node;
    }

    private void generateConnections(Map<org.jbpm.graph.def.Node, org.drools.workflow.core.Node> mapping) {
        for (Map.Entry<org.jbpm.graph.def.Node, org.drools.workflow.core.Node> entry : mapping.entrySet()) {
            List leavingTransitions = entry.getKey().getLeavingTransitions();
            if (leavingTransitions == null) continue;
            for (Transition transition : leavingTransitions) {
                List exceptionHandlers;
                org.drools.workflow.core.Node from = mapping.get(transition.getFrom());
                org.drools.workflow.core.Node to = mapping.get(transition.getTo());
                String transitionName = transition.getName();
                if (transitionName == null) {
                    transitionName = "DROOLS_DEFAULT";
                }
                JpdlConnection connection = new JpdlConnection(from, transitionName, to, "DROOLS_DEFAULT");
                Map events = transition.getEvents();
                if (events != null) {
                    for (Event event : events.values()) {
                        connection.addEvent(event);
                    }
                }
                if ((exceptionHandlers = transition.getExceptionHandlers()) != null) {
                    for (ExceptionHandler exceptionHandler : exceptionHandlers) {
                        connection.addExceptionHandler(exceptionHandler);
                    }
                }
                connection.setCondition(transition.getCondition());
            }
        }
    }

    private void setDefaultNodeProperties(org.jbpm.graph.def.Node jPDLnode, JpdlNode newNode) {
        List exceptionHandlers;
        newNode.setName(jPDLnode.getName());
        newNode.setAction(jPDLnode.getAction());
        Map events = jPDLnode.getEvents();
        if (events != null) {
            for (Event event : events.values()) {
                newNode.addEvent(event);
            }
        }
        if ((exceptionHandlers = jPDLnode.getExceptionHandlers()) != null) {
            for (ExceptionHandler exceptionHandler : exceptionHandlers) {
                newNode.addExceptionHandler(exceptionHandler);
            }
        }
    }

    public ProcessValidationError[] getErrors() {
        return this.errors;
    }

    static {
        EMAIL_PARAMETER_DEFINITIONS.add((ParameterDefinition)new ParameterDefinitionImpl("From", (DataType)new StringDataType()));
        EMAIL_PARAMETER_DEFINITIONS.add((ParameterDefinition)new ParameterDefinitionImpl("To", (DataType)new StringDataType()));
        EMAIL_PARAMETER_DEFINITIONS.add((ParameterDefinition)new ParameterDefinitionImpl("Subject", (DataType)new StringDataType()));
        EMAIL_PARAMETER_DEFINITIONS.add((ParameterDefinition)new ParameterDefinitionImpl("Text", (DataType)new StringDataType()));
    }
}

